/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.validation.ValidationErrorMessage;
import org.jboss.logging.validation.ValidationMessage;
import org.jboss.logging.validation.validator.AbstractValidator;

public class MethodParameterValidator
extends AbstractValidator {
    private static final String ERROR_MESSAGE = "The number of parameters, minus the cause parameter, must match all match all methods with the same name. Method %s accepts %d parameters and method %s accepts %d parameters.";

    public MethodParameterValidator(Annotations annotations, Types typeUtil) {
        super(annotations, typeUtil);
    }

    @Override
    public Collection<ValidationMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashSet<Name> methodNames = new HashSet<Name>();
        for (ExecutableElement method : elementMethods) {
            if (methodNames.add(method.getSimpleName())) {
                Collection<ExecutableElement> likeMethods = this.findByName(elementMethods, method.getSimpleName());
                int paramCount1 = method.getParameters().size() - (this.hasCause(method.getParameters()) ? 1 : 0);
                for (ExecutableElement m : likeMethods) {
                    int paramCount2 = m.getParameters().size() - (this.hasCause(m.getParameters()) ? 1 : 0);
                    if (paramCount1 == paramCount2) continue;
                    messages.add(ValidationErrorMessage.of(m, ERROR_MESSAGE, method.toString(), method.getParameters().size(), m.toString(), m.getParameters().size()));
                }
            }
            Annotation ogCause = null;
            for (VariableElement variableElement : method.getParameters()) {
                boolean invalid;
                Annotation cause = variableElement.getAnnotation(this.annotations.cause());
                boolean bl = invalid = ogCause != null && cause != null;
                if (invalid) {
                    messages.add(ValidationErrorMessage.of(variableElement, "Only one cause parameter allowed per method."));
                }
                ogCause = cause;
            }
        }
        return messages;
    }
}

