/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import java.io.IOException;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.jboss.logging.AbstractTool;
import org.jboss.logging.Annotations;
import org.jboss.logging.Loggers;
import org.jboss.logging.generator.MethodDescriptor;
import org.jboss.logging.model.ImplementationClassModel;
import org.jboss.logging.model.MessageBundleImplementor;
import org.jboss.logging.model.MessageLoggerImplementor;

public final class ImplementorClassGenerator
extends AbstractTool {
    public ImplementorClassGenerator(ProcessingEnvironment processingEnv, Annotations annotations, Loggers loggers) {
        super(processingEnv, annotations, loggers);
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, Collection<ExecutableElement> methods) {
        try {
            String interfaceName = this.elementUtils().getBinaryName(element).toString();
            if (element.getAnnotation(this.annotations().messageLogger()) != null) {
                this.createClass(new MessageLoggerImplementor(interfaceName, this.annotations().projectCode(element), this.extendsBasicLogger(element)), methods);
            }
            if (element.getAnnotation(this.annotations().messageBundle()) != null) {
                this.createClass(new MessageBundleImplementor(interfaceName, this.annotations().projectCode(element)), methods);
            }
        }
        catch (IOException e) {
            this.logger().error(element, e);
        }
        catch (IllegalStateException e) {
            this.logger().error(element, e);
        }
    }

    private void createClass(ImplementationClassModel classModel, Collection<ExecutableElement> methods) throws IOException, IllegalStateException {
        classModel.setMethodDescriptor(MethodDescriptor.create(this.elementUtils(), this.typeUtils(), methods, this.annotations()));
        classModel.create(this.filer().createSourceFile(classModel.getClassName(), new Element[0]));
    }

    private boolean extendsBasicLogger(TypeElement element) {
        if (element.getQualifiedName().toString().equals(this.loggers().basicLoggerClass().getName())) {
            return true;
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            if (!this.extendsBasicLogger((TypeElement)super.typeUtils().asElement(typeMirror))) continue;
            return true;
        }
        return false;
    }
}

