/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.SessionCookie;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AuthConstraintMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.ErrorPageMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.JspPropertyGroup;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingsMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.TaglibMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.metadata.web.spec.WelcomeFileListMetaData;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.tomcat.metadata.AnyXmlMetaData;
import org.jboss.web.tomcat.metadata.ContextMetaData;
import org.jboss.web.tomcat.metadata.ParameterMetaData;
import org.jboss.web.tomcat.service.deployers.DeployerConfig;
import org.jboss.web.tomcat.service.deployers.TomcatService;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.builder.JBossXBBuilder;
import org.xml.sax.EntityResolver;

public class JBossContextConfig
extends ContextConfig {
    public static ThreadLocal<JBossWebMetaData> metaDataLocal = new ThreadLocal();
    public static ThreadLocal<JBossWebMetaData> metaDataShared = new ThreadLocal();
    public static ThreadLocal<DeployerConfig> deployerConfig = new ThreadLocal();
    public static ThreadLocal<Kernel> kernelLocal = new ThreadLocal();
    public static ThreadLocal<DeploymentUnit> deploymentUnitLocal = new ThreadLocal();
    private static Logger log = Logger.getLogger(JBossContextConfig.class);
    private boolean runDestroy = false;

    public JBossContextConfig() {
        try {
            Map authMap = this.getAuthenticators();
            if (authMap.size() > 0) {
                this.customAuthenticators = authMap;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to load the customized authenticators", (Throwable)e);
        }
        this.runDestroy = deployerConfig.get().isDeleteWorkDirs();
    }

    protected void applicationWebConfig() {
        this.processWebMetaData(metaDataLocal.get());
        this.processContextParameters();
    }

    protected void defaultWebConfig() {
        this.processWebMetaData(metaDataShared.get());
        ServletContext servletContext = this.context.getServletContext();
        Kernel kernel = kernelLocal.get();
        DeploymentUnit unit = deploymentUnitLocal.get();
        log.debug((Object)("Setting MC attributes, kernel: " + kernel + ", unit: " + unit));
        servletContext.setAttribute("jboss.kernel:service=Kernel", (Object)kernel);
        servletContext.setAttribute(DeploymentUnit.class.getName(), (Object)unit);
    }

    protected void processWebMetaData(JBossWebMetaData metaData) {
        SessionConfigMetaData scmd;
        WelcomeFileListMetaData welcomeFiles;
        LocaleEncodingsMetaData locales;
        JspConfigMetaData config;
        List smappings;
        JBossServletsMetaData servlets;
        SecurityRolesMetaData roles;
        List scs;
        List mimes;
        LoginConfigMetaData loginConfig;
        List listeners;
        List filtersMappings;
        FiltersMetaData filters;
        List errorPages;
        String displayName;
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setReplaceWelcomeFiles(true);
        }
        this.context.setIgnoreAnnotations(metaData.isMetadataComplete());
        if (metaData.is25()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_2_5.dtd");
        } else if (metaData.is24()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_2_4.dtd");
        } else if (metaData.is23()) {
            this.context.setPublicId("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
        } else {
            this.context.setPublicId("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
        }
        DescriptionGroupMetaData dg = metaData.getDescriptionGroup();
        if (dg != null && (displayName = dg.getDisplayName()) != null) {
            this.context.setDisplayName(displayName);
        }
        if (metaData.getDistributable() != null) {
            this.context.setDistributable(true);
        }
        if ((errorPages = metaData.getErrorPages()) != null) {
            for (ErrorPageMetaData value : errorPages) {
                ErrorPage errorPage = new ErrorPage();
                errorPage.setErrorCode(value.getErrorCode());
                errorPage.setExceptionType(value.getExceptionType());
                errorPage.setLocation(value.getLocation());
                this.context.addErrorPage(errorPage);
            }
        }
        if ((filters = metaData.getFilters()) != null) {
            for (FilterMetaData value : filters) {
                FilterDef filterDef = new FilterDef();
                filterDef.setFilterName(value.getName());
                filterDef.setFilterClass(value.getFilterClass());
                if (value.getInitParam() != null) {
                    for (ParamValueMetaData param : value.getInitParam()) {
                        filterDef.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                this.context.addFilterDef(filterDef);
            }
        }
        if ((filtersMappings = metaData.getFilterMappings()) != null) {
            for (FilterMappingMetaData value : filtersMappings) {
                List dispatchers;
                List urlPatterns;
                FilterMap filterMap = new FilterMap();
                filterMap.setFilterName(value.getFilterName());
                List servletNames = value.getServletNames();
                if (servletNames != null) {
                    for (String name : servletNames) {
                        filterMap.addServletName(name);
                    }
                }
                if ((urlPatterns = value.getUrlPatterns()) != null) {
                    for (String pattern : urlPatterns) {
                        filterMap.addURLPattern(pattern);
                    }
                }
                if ((dispatchers = value.getDispatchers()) != null) {
                    for (DispatcherType type : dispatchers) {
                        filterMap.setDispatcher(type.name());
                    }
                }
                this.context.addFilterMap(filterMap);
            }
        }
        if ((listeners = metaData.getListeners()) != null) {
            for (ListenerMetaData value : listeners) {
                this.context.addApplicationListener(value.getListenerClass());
            }
        }
        if ((loginConfig = metaData.getLoginConfig()) != null) {
            LoginConfig loginConfig2 = new LoginConfig();
            loginConfig2.setAuthMethod(loginConfig.getAuthMethod());
            loginConfig2.setRealmName(loginConfig.getRealmName());
            if (loginConfig.getFormLoginConfig() != null) {
                loginConfig2.setLoginPage(loginConfig.getFormLoginConfig().getLoginPage());
                loginConfig2.setErrorPage(loginConfig.getFormLoginConfig().getErrorPage());
            }
            this.context.setLoginConfig(loginConfig2);
        }
        if ((mimes = metaData.getMimeMappings()) != null) {
            for (MimeMappingMetaData value : mimes) {
                this.context.addMimeMapping(value.getExtension(), value.getMimeType());
            }
        }
        if ((scs = metaData.getSecurityContraints()) != null) {
            for (SecurityConstraintMetaData value : scs) {
                WebResourceCollectionsMetaData wrcs;
                SecurityConstraint constraint = new SecurityConstraint();
                TransportGuaranteeType tg = value.getTransportGuarantee();
                constraint.setUserConstraint(tg.name());
                AuthConstraintMetaData acmd = value.getAuthConstraint();
                constraint.setAuthConstraint(acmd != null);
                if (acmd != null && acmd.getRoleNames() != null) {
                    for (String role : acmd.getRoleNames()) {
                        constraint.addAuthRole(role);
                    }
                }
                if ((wrcs = value.getResourceCollections()) != null) {
                    for (WebResourceCollectionMetaData wrc : wrcs) {
                        List patterns;
                        SecurityCollection collection2 = new SecurityCollection();
                        collection2.setName(wrc.getName());
                        List methods = wrc.getHttpMethods();
                        if (methods != null) {
                            for (String method : wrc.getHttpMethods()) {
                                collection2.addMethod(method);
                            }
                        }
                        if ((patterns = wrc.getUrlPatterns()) != null) {
                            for (String pattern : patterns) {
                                collection2.addPattern(pattern);
                            }
                        }
                        constraint.addCollection(collection2);
                    }
                }
                this.context.addConstraint(constraint);
            }
        }
        if ((roles = metaData.getSecurityRoles()) != null) {
            for (SecurityRoleMetaData value : roles) {
                this.context.addSecurityRole(value.getRoleName());
            }
        }
        if ((servlets = metaData.getServlets()) != null) {
            for (JBossServletMetaData value : servlets) {
                SecurityRoleRefsMetaData refs;
                List params;
                Wrapper wrapper = this.context.createWrapper();
                wrapper.setName(value.getName());
                wrapper.setServletClass(value.getServletClass());
                if (value.getJspFile() != null) {
                    wrapper.setJspFile(value.getJspFile());
                }
                wrapper.setLoadOnStartup(value.getLoadOnStartup());
                if (value.getRunAs() != null) {
                    wrapper.setRunAs(value.getRunAs().getRoleName());
                }
                if ((params = value.getInitParam()) != null) {
                    for (ParamValueMetaData param : params) {
                        wrapper.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                if ((refs = value.getSecurityRoleRefs()) != null) {
                    for (SecurityRoleRefMetaData ref : refs) {
                        wrapper.addSecurityReference(ref.getRoleName(), ref.getRoleLink());
                    }
                }
                this.context.addChild((Container)wrapper);
            }
        }
        if ((smappings = metaData.getServletMappings()) != null) {
            for (ServletMappingMetaData value : smappings) {
                List urlPatterns = value.getUrlPatterns();
                if (urlPatterns == null) continue;
                for (String pattern : urlPatterns) {
                    this.context.addServletMapping(pattern, value.getServletName());
                }
            }
        }
        if ((config = metaData.getJspConfig()) != null) {
            List taglibs;
            List groups = config.getPropertyGroups();
            if (groups != null) {
                for (JspPropertyGroup group : groups) {
                    for (String pattern : group.getUrlPatterns()) {
                        this.context.addJspMapping(pattern);
                    }
                }
            }
            if ((taglibs = config.getTaglibs()) != null) {
                for (TaglibMetaData taglib : taglibs) {
                    this.context.addTaglib(taglib.getTaglibUri(), taglib.getTaglibLocation());
                }
            }
        }
        if ((locales = metaData.getLocalEncodings()) != null) {
            for (LocaleEncodingMetaData value : locales.getMappings()) {
                this.context.addLocaleEncodingMappingParameter(value.getLocale(), value.getEncoding());
            }
        }
        if ((welcomeFiles = metaData.getWelcomeFileList()) != null) {
            for (String value : welcomeFiles.getWelcomeFiles()) {
                this.context.addWelcomeFile(value);
            }
        }
        if ((scmd = metaData.getSessionConfig()) != null) {
            this.context.setSessionTimeout(scmd.getSessionTimeout());
        }
    }

    protected Map getAuthenticators() throws Exception {
        HashMap authenticators = new HashMap();
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Properties authProps = this.getAuthenticatorsFromJndi();
        if (authProps != null) {
            Iterator<Object> iter;
            Set<Object> keys = authProps.keySet();
            Iterator<Object> iterator = iter = keys != null ? keys.iterator() : null;
            while (iter != null && iter.hasNext()) {
                String key = (String)iter.next();
                String authenticatorStr = (String)authProps.get(key);
                Class<?> authClass = tcl.loadClass(authenticatorStr);
                authenticators.put(key, authClass.newInstance());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Authenticators plugged in::" + authenticators));
        }
        return authenticators;
    }

    private Properties getAuthenticatorsFromJndi() throws NamingException {
        return (Properties)new InitialContext().lookup("TomcatAuthenticators");
    }

    protected void processContextParameters() {
        JBossWebMetaData local = metaDataLocal.get();
        JBossWebMetaData shared = metaDataShared.get();
        HashMap<String, String> overrideParams = new HashMap<String, String>();
        List params = local.getContextParams();
        if (params != null) {
            for (ParamValueMetaData param : params) {
                overrideParams.put(param.getParamName(), param.getParamValue());
            }
        }
        if ((params = shared.getContextParams()) != null) {
            for (ParamValueMetaData param : params) {
                if (overrideParams.get(param.getParamName()) != null) continue;
                overrideParams.put(param.getParamName(), param.getParamValue());
            }
        }
        for (String key : overrideParams.keySet()) {
            this.context.addParameter(key, (String)overrideParams.get(key));
        }
    }

    protected void init() {
        this.context.setConfigured(false);
        this.ok = true;
        if (!this.context.getOverride()) {
            this.processContextConfig("context.xml", false);
            this.processContextConfig(this.getHostConfigPath("context.xml.default"), false);
        }
        this.processContextConfig(this.context.getConfigFile(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextConfig(String resourceName, boolean local) {
        ContextMetaData contextMetaData = null;
        try {
            SchemaBinding schema = JBossXBBuilder.build(ContextMetaData.class);
            Unmarshaller u = UnmarshallerFactory.newInstance().newUnmarshaller();
            u.setSchemaValidation(false);
            u.setValidation(false);
            u.setEntityResolver((EntityResolver)new JBossEntityResolver());
            InputStream is = null;
            try {
                VFSDeploymentUnit vfsUnit;
                VirtualFile vf;
                DeploymentUnit localUnit;
                if (local && (localUnit = deploymentUnitLocal.get()) instanceof VFSDeploymentUnit && (vf = (vfsUnit = (VFSDeploymentUnit)localUnit).getFile(resourceName)) != null) {
                    is = vf.openStream();
                }
                if (is == null) {
                    is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);
                }
                if (is != null) {
                    contextMetaData = (ContextMetaData)ContextMetaData.class.cast(u.unmarshal(is, schema));
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("XML error parsing: " + resourceName), (Throwable)e);
            this.ok = false;
            return;
        }
        if (contextMetaData != null) {
            try {
                if (contextMetaData.getAttributes() != null) {
                    for (QName name : contextMetaData.getAttributes().keySet()) {
                        String value = (String)contextMetaData.getAttributes().get(name);
                        value = StringPropertyReplacer.replaceProperties((String)value);
                        IntrospectionUtils.setProperty((Object)this.context, (String)name.getLocalPart(), (String)value);
                    }
                }
                TomcatService.addLifecycleListeners(this.context, contextMetaData.getListeners());
                if (contextMetaData.getRealm() != null) {
                    this.context.setRealm((Realm)TomcatService.getInstance((AnyXmlMetaData)contextMetaData.getRealm(), null));
                }
                TomcatService.addValves(this.context, contextMetaData.getValves());
                if (contextMetaData.getInstanceListeners() != null) {
                    Iterator listeners = contextMetaData.getInstanceListeners().iterator();
                    while (listeners.hasNext()) {
                        this.context.addInstanceListener((String)listeners.next());
                    }
                }
                if (contextMetaData.getLoader() != null) {
                    this.context.setLoader((Loader)TomcatService.getInstance((AnyXmlMetaData)contextMetaData.getLoader(), "org.apache.catalina.loader.WebappLoader"));
                }
                if (contextMetaData.getManager() != null) {
                    this.context.setManager((Manager)TomcatService.getInstance((AnyXmlMetaData)contextMetaData.getManager(), "org.apache.catalina.session.StandardManager"));
                }
                if (contextMetaData.getParameters() != null) {
                    for (ParameterMetaData parameterMetaData : contextMetaData.getParameters()) {
                        this.context.addApplicationParameter((ApplicationParameter)TomcatService.getInstance((AnyXmlMetaData)parameterMetaData, null));
                    }
                }
                if (contextMetaData.getResources() != null) {
                    this.context.setResources((DirContext)TomcatService.getInstance((AnyXmlMetaData)contextMetaData.getResources(), "org.apache.naming.resources.FileDirContext"));
                }
                if (contextMetaData.getSessionCookie() != null) {
                    SessionCookie sessionCookie = new SessionCookie();
                    sessionCookie.setComment(contextMetaData.getSessionCookie().getComment());
                    sessionCookie.setDomain(contextMetaData.getSessionCookie().getDomain());
                    sessionCookie.setHttpOnly(contextMetaData.getSessionCookie().getHttpOnly());
                    sessionCookie.setPath(contextMetaData.getSessionCookie().getPath());
                    sessionCookie.setSecure(contextMetaData.getSessionCookie().getSecure());
                    this.context.setSessionCookie(sessionCookie);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error processing: " + resourceName), (Throwable)e);
                this.ok = false;
            }
        }
    }

    protected void destroy() {
        if (this.runDestroy) {
            super.destroy();
        }
    }
}

