/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static Principal getPrincipal() {
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                Principal principal = null;
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc != null) {
                    principal = sc.getUtil().getUserPrincipal();
                }
                return principal;
            }
        });
    }

    static Object getCredential() {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object credential = null;
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc != null) {
                    credential = sc.getUtil().getCredential();
                }
                return credential;
            }
        });
    }
}

