/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.vendor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
import org.jboss.util.NestedRuntimeException;

public class OracleValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 5379340663276548636L;
    private static transient Logger log;
    private static Object[] params;
    private transient Method ping;

    public OracleValidConnectionChecker() {
        try {
            this.initPing();
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Unable to resolve pingDatabase method:", (Throwable)e);
        }
    }

    public SQLException isValidConnection(Connection c) {
        try {
            Integer status = (Integer)this.ping.invoke((Object)c, params);
            if (status == null || status < 0) {
                return new SQLException("pingDatabase failed status=" + status);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected error in pingDatabase", (Throwable)e);
        }
        return null;
    }

    private void initPing() throws ClassNotFoundException, NoSuchMethodException {
        log = Logger.getLogger(OracleValidConnectionChecker.class);
        Class<?> oracleConnection = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.driver.OracleConnection");
        this.ping = oracleConnection.getMethod("pingDatabase", Integer.TYPE);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            this.initPing();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to resolve pingDatabase method: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    static {
        params = new Object[]{new Integer(5000)};
    }
}

