/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.vfs.plugins.vfs.VirtualFileSerializator;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.virtual.VirtualFile;

public class AbstractVFSDeployment
extends AbstractDeployment
implements VFSDeployment {
    private static final long serialVersionUID = 2L;
    private boolean directRootSerialization;
    private transient VirtualFile root;

    static final String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            return root.toURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public AbstractVFSDeployment() {
    }

    public AbstractVFSDeployment(VirtualFile root) {
        super(AbstractVFSDeployment.safeVirtualFileName(root));
        this.root = root;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public String getSimpleName() {
        return this.getRoot().getName();
    }

    public String toString() {
        return "AbstractVFSDeployment(" + this.getSimpleName() + ")";
    }

    public void setDirectRootSerialization(boolean directRootSerialization) {
        this.directRootSerialization = directRootSerialization;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.directRootSerialization = in.readBoolean();
        if (this.directRootSerialization) {
            this.root = (VirtualFile)in.readObject();
        } else {
            VirtualFileSerializator serializator = (VirtualFileSerializator)in.readObject();
            this.root = serializator.getFile();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.directRootSerialization);
        if (this.directRootSerialization) {
            out.writeObject(this.root);
        } else {
            out.writeObject(new VirtualFileSerializator(this.root));
        }
    }
}

