/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.deployers.vfs.spi.structure.modified.AbstractSynchAdapter;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

public class OverrideSynchAdapter
extends AbstractSynchAdapter {
    public long update(VirtualFile fileToUpdate, VirtualFile modifiedFile) throws IOException {
        return OverrideSynchAdapter.override(fileToUpdate, modifiedFile);
    }

    static long override(VirtualFile fileToOverride, VirtualFile modifiedFile) throws IOException {
        try {
            URI uri = VFSUtils.getRealURL((VirtualFile)fileToOverride).toURI();
            if (fileToOverride.delete()) {
                File newFile = new File(uri);
                return OverrideSynchAdapter.copy(modifiedFile, newFile);
            }
            log.warn((Object)("Could not delete previous file: " + fileToOverride + ", no change applied: " + modifiedFile));
            return fileToOverride.getLastModified();
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

