/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.io.Closeable;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.ear.spec.Ear6xMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.parser.spec.EarMetaDataParser;
import org.jboss.metadata.parser.util.NoopXmlResolver;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class EarMetaDataParsingProcessor
implements DeploymentUnitProcessor {
    private static final String APPLICATION_XML = "META-INF/application.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        VirtualFile deploymentFile = deploymentRoot.getRoot();
        VirtualFile applicationXmlFile = deploymentFile.getChild(APPLICATION_XML);
        if (!applicationXmlFile.exists()) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = applicationXmlFile.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXmlResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(inputStream);
            EarMetaData earMetaData = EarMetaDataParser.parse((XMLStreamReader)xmlReader);
            if (earMetaData != null) {
                Ear6xMetaData metaData;
                deploymentUnit.putAttachment(Attachments.EAR_METADATA, (Object)earMetaData);
                if (earMetaData instanceof Ear6xMetaData && (metaData = (Ear6xMetaData)earMetaData).getEarEnvironmentRefsGroup() != null) {
                    DeploymentDescriptorEnvironment bindings = new DeploymentDescriptorEnvironment("java:app/env/", (RemoteEnvironment)((Ear6xMetaData)earMetaData).getEarEnvironmentRefsGroup());
                    deploymentUnit.putAttachment(org.jboss.as.ee.component.Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT, (Object)bindings);
                }
            }
        }
        catch (Exception e) {
            throw EeMessages.MESSAGES.failedToParse(e, applicationXmlFile);
        }
        finally {
            VFSUtils.safeClose((Closeable)inputStream);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.EAR_METADATA);
    }
}

