/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;

final class ManagedReferenceLifecycleMethodInterceptorFactory
implements InterceptorFactory {
    private final Object contextKey;
    private final Method method;
    private final boolean changeMethod;
    private final boolean lifecycleMethod;

    ManagedReferenceLifecycleMethodInterceptorFactory(Object contextKey, Method method, boolean changeMethod) {
        this(contextKey, method, changeMethod, false);
    }

    ManagedReferenceLifecycleMethodInterceptorFactory(Object contextKey, Method method, boolean changeMethod, boolean lifecycleMethod) {
        this.contextKey = contextKey;
        this.method = method;
        this.changeMethod = changeMethod;
        this.lifecycleMethod = lifecycleMethod;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        AtomicReference ref = (AtomicReference)context.getContextData().get(this.contextKey);
        return new ManagedReferenceLifecycleMethodInterceptor(ref, this.method, this.changeMethod, this.lifecycleMethod);
    }

    static final class ManagedReferenceLifecycleMethodInterceptor
    implements Interceptor {
        private final AtomicReference<ManagedReference> instanceRef;
        private final Method method;
        private final boolean withContext;
        private final boolean changeMethod;
        private final boolean lifecycleMethod;

        ManagedReferenceLifecycleMethodInterceptor(AtomicReference<ManagedReference> instanceRef, Method method, boolean changeMethod, boolean lifecycleMethod) {
            this.changeMethod = changeMethod;
            this.method = method;
            this.lifecycleMethod = lifecycleMethod;
            this.instanceRef = instanceRef;
            this.withContext = method.getParameterTypes().length == 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            ManagedReference reference = this.instanceRef.get();
            Object instance = reference.getInstance();
            try {
                Method method = this.method;
                if (!this.withContext) {
                    method.invoke(instance, null);
                    return context.proceed();
                }
                Method oldMethod = context.getMethod();
                try {
                    if (this.lifecycleMethod) {
                        context.setMethod(null);
                        Object object = method.invoke(instance, context.getInvocationContext());
                        return object;
                    }
                    if (this.changeMethod) {
                        context.setMethod(method);
                        Object object = method.invoke(instance, context.getInvocationContext());
                        return object;
                    }
                    Object object = method.invoke(instance, context.getInvocationContext());
                    return object;
                }
                finally {
                    context.setMethod(oldMethod);
                }
            }
            catch (IllegalAccessException e) {
                IllegalAccessError n = new IllegalAccessError(e.getMessage());
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
            catch (InvocationTargetException e) {
                throw Interceptors.rethrow((Throwable)e.getCause());
            }
        }
    }
}

