/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.threads.AsyncFuture;

public abstract class AbstractModelControllerClient
extends AbstractMessageHandler<ModelNode, OperationExecutionContext>
implements ModelControllerClient {
    private static ManagementRequestHandler<ModelNode, OperationExecutionContext> MESSAGE_HANDLER = new HandleReportRequestHandler();
    private static ManagementRequestHandler<ModelNode, OperationExecutionContext> GET_INPUT_STREAM = new ReadAttachmentInputStreamRequestHandler();
    private static final OperationMessageHandler NO_OP_HANDLER = new OperationMessageHandler(){

        @Override
        public void handleReport(MessageSeverity severity, String message) {
        }
    };

    protected AbstractModelControllerClient(ExecutorService executorService) {
        super(executorService);
    }

    protected abstract Channel getChannel() throws IOException;

    @Override
    public ModelNode execute(ModelNode operation) throws IOException {
        return this.executeForResult(OperationExecutionContext.create(operation));
    }

    @Override
    public ModelNode execute(Operation operation) throws IOException {
        return this.executeForResult(OperationExecutionContext.create(operation));
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.executeForResult(OperationExecutionContext.create(operation, messageHandler));
    }

    @Override
    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.executeForResult(OperationExecutionContext.create(operation, messageHandler));
    }

    @Override
    public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        try {
            return this.execute(OperationExecutionContext.create(operation, messageHandler));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        try {
            return this.execute(OperationExecutionContext.create(operation, messageHandler));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ManagementRequestHandler<ModelNode, OperationExecutionContext> getRequestHandler(byte operationType) {
        if (operationType == 72) {
            return MESSAGE_HANDLER;
        }
        if (operationType == 76) {
            return GET_INPUT_STREAM;
        }
        return super.getRequestHandler(operationType);
    }

    private ModelNode executeForResult(OperationExecutionContext executionContext) throws IOException {
        try {
            return (ModelNode)this.execute(executionContext).get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private AsyncFuture<ModelNode> execute(final OperationExecutionContext executionContext) throws IOException {
        return this.executeRequest((ManagementRequest<ModelNode, OperationExecutionContext>)new AbstractManagementRequest<ModelNode, OperationExecutionContext>(){

            public byte getOperationType() {
                return 69;
            }

            protected void sendRequest(ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<OperationExecutionContext> context, FlushableDataOutput output) throws IOException {
                List<InputStream> streams = executionContext.operation.getInputStreams();
                ModelNode operation = executionContext.operation.getOperation();
                int inputStreamLength = 0;
                if (streams != null) {
                    inputStreamLength = streams.size();
                }
                output.write(97);
                operation.writeExternal((DataOutput)output);
                output.write(101);
                output.writeInt(inputStreamLength);
            }

            public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<OperationExecutionContext> context) throws IOException {
                ProtocolUtils.expectHeader((DataInput)input, (int)100);
                ModelNode node = new ModelNode();
                node.readExternal(input);
                resultHandler.done((Object)node);
                ProtocolUtils.expectHeader((DataInput)input, (int)36);
            }
        }, executionContext);
    }

    protected AsyncFuture<ModelNode> executeRequest(ManagementRequest<ModelNode, OperationExecutionContext> request, OperationExecutionContext attachment) throws IOException {
        ActiveOperation support = super.registerActiveOperation((Object)attachment, (ActiveOperation.CompletedCallback)attachment);
        return new DelegatingCancellableAsyncFuture((AsyncFuture<ModelNode>)super.executeRequest(request, this.getChannel(), support), support.getOperationId());
    }

    private class DelegatingCancellableAsyncFuture
    implements AsyncFuture<ModelNode> {
        private final int batchId;
        private final AsyncFuture<ModelNode> delegate;

        public DelegatingCancellableAsyncFuture(AsyncFuture<ModelNode> delegate, int batchId) {
            this.delegate = delegate;
            this.batchId = batchId;
        }

        public AsyncFuture.Status await() throws InterruptedException {
            return this.delegate.await();
        }

        public AsyncFuture.Status await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.await(timeout, unit);
        }

        public ModelNode getUninterruptibly() throws CancellationException, ExecutionException {
            return (ModelNode)this.delegate.getUninterruptibly();
        }

        public ModelNode getUninterruptibly(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, TimeoutException {
            return (ModelNode)this.delegate.getUninterruptibly(timeout, unit);
        }

        public AsyncFuture.Status awaitUninterruptibly() {
            return this.delegate.awaitUninterruptibly();
        }

        public AsyncFuture.Status awaitUninterruptibly(long timeout, TimeUnit unit) {
            return this.delegate.awaitUninterruptibly(timeout, unit);
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }

        public AsyncFuture.Status getStatus() {
            return this.delegate.getStatus();
        }

        public <A> void addListener(AsyncFuture.Listener<? super ModelNode, A> listener, A attachment) {
            this.delegate.addListener(listener, attachment);
        }

        public ModelNode get() throws InterruptedException, ExecutionException {
            return (ModelNode)this.delegate.get();
        }

        public ModelNode get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (ModelNode)this.delegate.get(timeout, unit);
        }

        public boolean isCancelled() {
            return this.delegate.getStatus() == AsyncFuture.Status.CANCELLED;
        }

        public boolean cancel(boolean interruptionDesired) {
            this.asyncCancel(interruptionDesired);
            return this.awaitUninterruptibly() == AsyncFuture.Status.CANCELLED;
        }

        public void asyncCancel(boolean interruptionDesired) {
            try {
                ActiveOperation support = AbstractModelControllerClient.this.getActiveOperation(this.batchId);
                if (support != null) {
                    AbstractModelControllerClient.this.executeRequest((ManagementRequest)new CancelAsyncRequest(), AbstractModelControllerClient.this.getChannel(), support);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private class CancelAsyncRequest
        extends AbstractManagementRequest<ModelNode, OperationExecutionContext> {
            private CancelAsyncRequest() {
            }

            public byte getOperationType() {
                return 77;
            }

            protected void sendRequest(ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<OperationExecutionContext> context, FlushableDataOutput output) throws IOException {
            }

            public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<OperationExecutionContext> context) throws IOException {
                resultHandler.cancel();
            }
        }
    }

    static class OperationExecutionContext
    implements ActiveOperation.CompletedCallback<ModelNode> {
        private final Operation operation;
        private final OperationMessageHandler handler;

        OperationExecutionContext(Operation operation, OperationMessageHandler handler) {
            this.operation = operation;
            this.handler = handler != null ? handler : NO_OP_HANDLER;
        }

        Operation getOperation() {
            return this.operation;
        }

        OperationMessageHandler getOperationMessageHandler() {
            return this.handler;
        }

        public void completed(ModelNode result) {
            this.closeAttachments();
        }

        public void failed(Exception e) {
            this.closeAttachments();
        }

        public void cancelled() {
            this.closeAttachments();
        }

        private void closeAttachments() {
            if (this.operation.isAutoCloseStreams()) {
                StreamUtils.safeClose((Closeable)this.operation);
            }
        }

        static OperationExecutionContext create(ModelNode operation) {
            return OperationExecutionContext.create(new OperationBuilder(operation).build(), NO_OP_HANDLER);
        }

        static OperationExecutionContext create(Operation operation) {
            return OperationExecutionContext.create(operation, NO_OP_HANDLER);
        }

        static OperationExecutionContext create(ModelNode operation, OperationMessageHandler handler) {
            return OperationExecutionContext.create(new OperationBuilder(operation).build(), handler);
        }

        static OperationExecutionContext create(Operation operation, OperationMessageHandler handler) {
            return new OperationExecutionContext(operation, handler);
        }
    }

    private static class HandleReportRequestHandler
    implements ManagementRequestHandler<ModelNode, OperationExecutionContext> {
        private HandleReportRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<OperationExecutionContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader((DataInput)input, (int)99);
            String message = input.readUTF();
            ProtocolUtils.expectHeader((DataInput)input, (int)21);
            OperationExecutionContext requestContext = (OperationExecutionContext)context.getAttachment();
            OperationMessageHandler handler = requestContext.getOperationMessageHandler();
            handler.handleReport(severity, message);
        }
    }

    private static class ReadAttachmentInputStreamRequestHandler
    implements ManagementRequestHandler<ModelNode, OperationExecutionContext> {
        private ReadAttachmentInputStreamRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<OperationExecutionContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            final int index = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<OperationExecutionContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<OperationExecutionContext> context) throws Exception {
                    OperationExecutionContext exec = (OperationExecutionContext)context.getAttachment();
                    ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    InputStream is = exec.getOperation().getInputStreams().get(index);
                    ByteArrayOutputStream bout = ReadAttachmentInputStreamRequestHandler.this.copyStream(is);
                    FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                    try {
                        output.writeByte(103);
                        output.writeInt(bout.size());
                        output.writeByte(104);
                        output.write(bout.toByteArray());
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            });
        }

        protected ByteArrayOutputStream copyStream(InputStream is) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (is != null) {
                StreamUtils.copyStream((InputStream)is, (OutputStream)bout);
            }
            return bout;
        }
    }
}

