/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.Serializer;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXMethodExecutor
implements ContainerMethodExecutor {
    private static Logger log = Logger.getLogger(JMXMethodExecutor.class);
    private final MBeanServerConnection mbeanServer;
    private final CommandCallback callback;

    public JMXMethodExecutor(MBeanServerConnection mbeanServer, CommandCallback callbac) {
        this.mbeanServer = mbeanServer;
        this.callback = callbac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor null");
        }
        String testClass = testMethodExecutor.getInstance().getClass().getName();
        String testMethod = testMethodExecutor.getMethod().getName();
        String testCanonicalName = testClass + "." + testMethod;
        CallbackNotificationListener commandListener = null;
        ObjectName objectName = null;
        TestResult result = null;
        try {
            objectName = new ObjectName("jboss.arquillian:service=jmx-test-runner");
            commandListener = new CallbackNotificationListener(objectName);
            this.mbeanServer.addNotificationListener(objectName, commandListener, null, null);
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(objectName, JMXTestRunnerMBean.class);
            log.debugf("Invoke %s", (Object)testCanonicalName);
            result = Serializer.toObject(TestResult.class, testRunner.runTestMethod(testClass, testMethod));
        }
        catch (Throwable th) {
            result = new TestResult(TestResult.Status.FAILED);
            result.setThrowable(th);
        }
        finally {
            result.setEnd(System.currentTimeMillis());
            if (objectName != null && commandListener != null) {
                try {
                    this.mbeanServer.removeNotificationListener(objectName, commandListener);
                }
                catch (Throwable th) {
                    log.errorf(th, "Cannot remove notification listener", new Object[0]);
                }
            }
        }
        log.debugf("Result: %s", (Object)result);
        if (result.getStatus() == TestResult.Status.FAILED) {
            log.errorf(result.getThrowable(), "Failed: %s", (Object)testCanonicalName);
        }
        return result;
    }

    private <T> T getMBeanProxy(ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, interf, false);
    }

    private class CallbackNotificationListener
    implements NotificationListener {
        private ObjectName serviceName;

        public CallbackNotificationListener(ObjectName serviceName) {
            this.serviceName = serviceName;
        }

        public void handleNotification(Notification notification, Object handback) {
            String eventMessage = notification.getMessage();
            Command command = Serializer.toObject(Command.class, (byte[])notification.getUserData());
            JMXMethodExecutor.this.callback.fired(command);
            try {
                JMXMethodExecutor.this.mbeanServer.invoke(this.serviceName, "push", new Object[]{eventMessage, Serializer.toByteArray(command)}, new String[]{String.class.getName(), byte[].class.getName()});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not return command result for command " + command, e);
            }
        }
    }
}

