/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;

public class UrlUtils {
    public static boolean isSeleniumHubRunningOnDefaultUrl() {
        return UrlUtils.isReachable(WebDriverConfiguration.DEFAULT_REMOTE_URL);
    }

    public static boolean isReachable(URL url) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(url.getHost(), url.getPort()), 1000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public static boolean isLocalhost(URL url) {
        try {
            InetAddress address = InetAddress.getByName(url.getHost());
            if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
                return true;
            }
            try {
                return NetworkInterface.getByInetAddress(address) != null;
            }
            catch (SocketException e) {
                return false;
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

