/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.embedded_3_1;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

class InstanceRootFilter
implements FileFilter {
    private static final Logger logger = Logger.getLogger(InstanceRootFilter.class.getName());
    private boolean ignoreConfigXml;

    public InstanceRootFilter(boolean ignoreConfigXml) {
        this.ignoreConfigXml = ignoreConfigXml;
    }

    public boolean accept(File pathname) {
        if (pathname.getName().equals("docroot")) {
            return true;
        }
        if (pathname.getName().equals("config") && pathname.isDirectory()) {
            if (this.ignoreConfigXml) {
                return true;
            }
            List<String> filesInConfigDir = Arrays.asList(pathname.list());
            if (filesInConfigDir.contains("domain.xml")) {
                logger.warning("A domain.xml file was found in the instanceRoot. The file specified in the configurationXml property of arquillian.xml might be ignored by embedded Glassfish.");
            }
            return true;
        }
        return false;
    }
}

