/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.jasig.services.persondir.support.AttributeNamedPersonImpl;
import org.jasig.services.persondir.support.BasePersonImpl;
import org.jasig.services.persondir.support.IUsernameAttributeProvider;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.NamedPersonImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryPersonAttributeDao<QB>
extends AbstractDefaultAttributePersonAttributeDao {
    private Map<String, Set<String>> queryAttributeMapping;
    private Map<String, Set<String>> resultAttributeMapping;
    private Set<String> possibleUserAttributes;
    private boolean requireAllQueryAttributes = false;
    private String unmappedUsernameAttribute = null;

    public Map<String, Set<String>> getQueryAttributeMapping() {
        return this.queryAttributeMapping;
    }

    public void setQueryAttributeMapping(Map<String, ?> queryAttributeMapping) {
        Map<String, Set<String>> parsedQueryAttributeMapping = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(queryAttributeMapping);
        if (parsedQueryAttributeMapping.containsKey("")) {
            throw new IllegalArgumentException("The map from attribute names to attributes must not have any empty keys.");
        }
        this.queryAttributeMapping = parsedQueryAttributeMapping;
    }

    public Map<String, Set<String>> getResultAttributeMapping() {
        return this.resultAttributeMapping;
    }

    public void setResultAttributeMapping(Map<String, ?> resultAttributeMapping) {
        Map<String, Set<String>> parsedResultAttributeMapping = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(resultAttributeMapping);
        if (parsedResultAttributeMapping.containsKey("")) {
            throw new IllegalArgumentException("The map from attribute names to attributes must not have any empty keys.");
        }
        Collection userAttributes = MultivaluedPersonAttributeUtils.flattenCollection(parsedResultAttributeMapping.values());
        this.resultAttributeMapping = parsedResultAttributeMapping;
        this.possibleUserAttributes = Collections.unmodifiableSet(new LinkedHashSet(userAttributes));
    }

    public boolean isRequireAllQueryAttributes() {
        return this.requireAllQueryAttributes;
    }

    public void setRequireAllQueryAttributes(boolean requireAllQueryAttributes) {
        this.requireAllQueryAttributes = requireAllQueryAttributes;
    }

    public String getUnmappedUsernameAttribute() {
        return this.unmappedUsernameAttribute;
    }

    public void setUnmappedUsernameAttribute(String userNameAttribute) {
        this.unmappedUsernameAttribute = userNameAttribute;
    }

    public final Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        Validate.notNull(query, (String)"query may not be null.");
        QB queryBuilder = this.generateQuery(query);
        if (queryBuilder == null) {
            this.logger.debug((Object)("No queryBuilder was generated for query " + query + ", null will be returned"));
            return null;
        }
        IUsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
        String username = usernameAttributeProvider.getUsernameFromQuery(query);
        List<IPersonAttributes> unmappedPeople = this.getPeopleForQuery(queryBuilder, username);
        if (unmappedPeople == null) {
            return null;
        }
        LinkedHashSet<IPersonAttributes> mappedPeople = new LinkedHashSet<IPersonAttributes>();
        for (IPersonAttributes unmappedPerson : unmappedPeople) {
            IPersonAttributes mappedPerson = this.mapPersonAttributes(unmappedPerson);
            mappedPeople.add(mappedPerson);
        }
        return Collections.unmodifiableSet(mappedPeople);
    }

    public Set<String> getAvailableQueryAttributes() {
        return Collections.unmodifiableSet(this.queryAttributeMapping.keySet());
    }

    public Set<String> getPossibleUserAttributeNames() {
        return this.possibleUserAttributes;
    }

    protected abstract List<IPersonAttributes> getPeopleForQuery(QB var1, String var2);

    protected abstract QB appendAttributeToQuery(QB var1, String var2, List<Object> var3);

    protected final QB generateQuery(Map<String, List<Object>> query) {
        Object queryBuilder = null;
        if (this.queryAttributeMapping != null) {
            for (Map.Entry<String, Set<String>> queryAttrEntry : this.queryAttributeMapping.entrySet()) {
                String queryAttr = queryAttrEntry.getKey();
                List<Object> queryValues = query.get(queryAttr);
                if (queryValues != null) {
                    Set<String> dataAttributes = queryAttrEntry.getValue();
                    if (dataAttributes == null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Adding attribute '" + queryAttr + "' with value '" + queryValues + "' to query builder '" + queryBuilder + "'"));
                        }
                        queryBuilder = this.appendAttributeToQuery(queryBuilder, null, queryValues);
                        continue;
                    }
                    for (String dataAttribute : dataAttributes) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Adding attribute '" + dataAttribute + "' with value '" + queryValues + "' to query builder '" + queryBuilder + "'"));
                        }
                        queryBuilder = this.appendAttributeToQuery(queryBuilder, dataAttribute, queryValues);
                    }
                    continue;
                }
                if (!this.requireAllQueryAttributes) continue;
                this.logger.debug((Object)("Query " + query + " does not contain all nessesary attributes as specified by queryAttributeMapping " + this.queryAttributeMapping + ", null will be returned for the queryBuilder"));
                return null;
            }
        } else {
            for (Map.Entry<String, List<Object>> queryAttrEntry : query.entrySet()) {
                String queryKey = queryAttrEntry.getKey();
                List<Object> queryValues = queryAttrEntry.getValue();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Adding attribute '" + queryKey + "' with value '" + queryValues + "' to query builder '" + queryBuilder + "'"));
                }
                queryBuilder = this.appendAttributeToQuery(queryBuilder, queryKey, queryValues);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated query builder '" + queryBuilder + "' from query Map " + query + "."));
        }
        return queryBuilder;
    }

    protected final IPersonAttributes mapPersonAttributes(IPersonAttributes person) {
        BasePersonImpl newPerson;
        LinkedHashMap<String, List<Object>> mappedAttributes;
        LinkedHashMap<String, List<Object>> personAttributes = person.getAttributes();
        if (this.resultAttributeMapping == null) {
            mappedAttributes = personAttributes;
        } else {
            mappedAttributes = new LinkedHashMap<String, List<Object>>();
            for (Map.Entry<String, Set<String>> resultAttrEntry : this.resultAttributeMapping.entrySet()) {
                String dataKey = resultAttrEntry.getKey();
                if (!personAttributes.containsKey(dataKey)) continue;
                Set<String> resultKeys = resultAttrEntry.getValue();
                if (resultKeys == null) {
                    resultKeys = Collections.singleton(dataKey);
                }
                List value = (List)personAttributes.get(dataKey);
                for (String resultKey : resultKeys) {
                    if (resultKey == null) {
                        mappedAttributes.put(dataKey, value);
                        continue;
                    }
                    mappedAttributes.put(resultKey, value);
                }
            }
        }
        String name = person.getName();
        if (name != null) {
            newPerson = new NamedPersonImpl(name, mappedAttributes);
        } else {
            String userNameAttribute = this.getConfiguredUserNameAttribute();
            newPerson = new AttributeNamedPersonImpl(userNameAttribute, mappedAttributes);
        }
        return newPerson;
    }

    protected String getConfiguredUserNameAttribute() {
        if (this.unmappedUsernameAttribute != null) {
            return this.unmappedUsernameAttribute;
        }
        IUsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
        return usernameAttributeProvider.getUsernameAttribute();
    }
}

