/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jasig.services.persondir.support.IAdditionalDescriptors;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.springframework.web.filter.GenericFilterBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestAttributeSourceFilter
extends GenericFilterBean {
    private String usernameAttribute;
    private Map<String, Set<String>> headerAttributeMapping = Collections.emptyMap();
    private IAdditionalDescriptors additionalDescriptors;
    private String remoteUserAttribute;
    private String remoteAddrAttribute;
    private String remoteHostAttribute;
    private String serverNameAttribute;
    private String serverPortAttribute;
    private boolean clearExistingAttributes = false;
    private ProcessingPosition processingPosition = ProcessingPosition.POST;

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getRemoteUserAttribute() {
        return this.remoteUserAttribute;
    }

    public void setRemoteUserAttribute(String remoteUserAttribute) {
        this.remoteUserAttribute = remoteUserAttribute;
    }

    public String getRemoteAddrAttribute() {
        return this.remoteAddrAttribute;
    }

    public void setRemoteAddrAttribute(String remoteAddrAttribute) {
        this.remoteAddrAttribute = remoteAddrAttribute;
    }

    public String getRemoteHostAttribute() {
        return this.remoteHostAttribute;
    }

    public void setRemoteHostAttribute(String remoteHostAttribute) {
        this.remoteHostAttribute = remoteHostAttribute;
    }

    public String getServerNameAttribute() {
        return this.serverNameAttribute;
    }

    public void setServerNameAttribute(String serverNameAttribute) {
        this.serverNameAttribute = serverNameAttribute;
    }

    public String getServerPortAttribute() {
        return this.serverPortAttribute;
    }

    public void setServerPortAttribute(String serverPortAttribute) {
        this.serverPortAttribute = serverPortAttribute;
    }

    public IAdditionalDescriptors getAdditionalDescriptors() {
        return this.additionalDescriptors;
    }

    public void setAdditionalDescriptors(IAdditionalDescriptors additionalDescriptors) {
        this.additionalDescriptors = additionalDescriptors;
    }

    public boolean isClearExistingAttributes() {
        return this.clearExistingAttributes;
    }

    public void setClearExistingAttributes(boolean clearExistingAttributes) {
        this.clearExistingAttributes = clearExistingAttributes;
    }

    public ProcessingPosition getProcessingPosition() {
        return this.processingPosition;
    }

    public void setProcessingPosition(ProcessingPosition processingPosition) {
        this.processingPosition = processingPosition;
    }

    public Map<String, Set<String>> getHeaderAttributeMapping() {
        return this.headerAttributeMapping;
    }

    public void setHeaderAttributeMapping(Map<String, ?> headerAttributeMapping) {
        Map<String, Set<String>> parsedHeaderAttributeMapping = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(headerAttributeMapping);
        if (parsedHeaderAttributeMapping.containsKey("")) {
            throw new IllegalArgumentException("The map from attribute names to attributes must not have any empty keys.");
        }
        this.headerAttributeMapping = parsedHeaderAttributeMapping;
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (ProcessingPosition.PRE == this.processingPosition || ProcessingPosition.BOTH == this.processingPosition) {
            this.doProcessing(servletRequest);
        }
        chain.doFilter(servletRequest, servletResponse);
        if (ProcessingPosition.POST == this.processingPosition || ProcessingPosition.BOTH == this.processingPosition) {
            this.doProcessing(servletRequest);
        }
    }

    private void doProcessing(ServletRequest servletRequest) {
        if (servletRequest instanceof HttpServletRequest) {
            String username;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
            this.addRequestProperties(httpServletRequest, attributes);
            this.addRequestHeaders(httpServletRequest, attributes);
            List usernameAttributes = (List)attributes.get(this.usernameAttribute);
            if (usernameAttributes == null || usernameAttributes.isEmpty() || usernameAttributes.get(0) == null) {
                this.logger.warn((Object)("No username found for attribute '" + this.usernameAttribute + "' among " + attributes));
                username = null;
            } else {
                username = usernameAttributes.get(0).toString();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding attributes for user " + username + ". " + attributes));
            }
            this.additionalDescriptors.setName(username);
            if (this.clearExistingAttributes) {
                this.additionalDescriptors.setAttributes(attributes);
            } else {
                this.additionalDescriptors.addAttributes(attributes);
            }
        }
    }

    protected void addRequestProperties(HttpServletRequest httpServletRequest, Map<String, List<Object>> attributes) {
        if (this.remoteUserAttribute != null) {
            String remoteUser = httpServletRequest.getRemoteUser();
            attributes.put(this.remoteUserAttribute, this.list(remoteUser));
        }
        if (this.remoteAddrAttribute != null) {
            String remoteAddr = httpServletRequest.getRemoteAddr();
            attributes.put(this.remoteAddrAttribute, this.list(remoteAddr));
        }
        if (this.remoteHostAttribute != null) {
            String remoteHost = httpServletRequest.getRemoteHost();
            attributes.put(this.remoteHostAttribute, this.list(remoteHost));
        }
        if (this.serverNameAttribute != null) {
            String serverName = httpServletRequest.getServerName();
            attributes.put(this.serverNameAttribute, this.list(serverName));
        }
        if (this.serverPortAttribute != null) {
            int serverPort = httpServletRequest.getServerPort();
            attributes.put(this.serverPortAttribute, this.list(serverPort));
        }
    }

    protected void addRequestHeaders(HttpServletRequest httpServletRequest, Map<String, List<Object>> attributes) {
        for (Map.Entry<String, Set<String>> headerAttributeEntry : this.headerAttributeMapping.entrySet()) {
            String headerName = headerAttributeEntry.getKey();
            String value = httpServletRequest.getHeader(headerName);
            if (value == null) continue;
            for (String attribueName : headerAttributeEntry.getValue()) {
                attributes.put(attribueName, this.list(value));
            }
        }
    }

    private List<Object> list(Object value) {
        return Arrays.asList(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProcessingPosition {
        PRE,
        POST,
        BOTH;

    }
}

