/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.xml;

import java.io.IOException;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.report.internal.xml.XMLElement;

public final class XMLCoverageWriter {
    public static XMLElement createChild(XMLElement parent, String tagname, String name) throws IOException {
        XMLElement child = parent.element(tagname);
        child.attr("name", name);
        return child;
    }

    public static void writeBundle(IBundleCoverage bundle, XMLElement element) throws IOException {
        for (IPackageCoverage p : bundle.getPackages()) {
            XMLCoverageWriter.writePackage(p, element);
        }
        XMLCoverageWriter.writeCounters((ICoverageNode)bundle, element);
    }

    private static void writePackage(IPackageCoverage p, XMLElement parent) throws IOException {
        XMLElement element = XMLCoverageWriter.createChild(parent, "package", p.getName());
        for (IClassCoverage c : p.getClasses()) {
            XMLCoverageWriter.writeClass(c, element);
        }
        for (ISourceFileCoverage s : p.getSourceFiles()) {
            XMLCoverageWriter.writeSourceFile(s, element);
        }
        XMLCoverageWriter.writeCounters((ICoverageNode)p, element);
    }

    private static void writeClass(IClassCoverage c, XMLElement parent) throws IOException {
        XMLElement element = XMLCoverageWriter.createChild(parent, "class", c.getName());
        for (IMethodCoverage m : c.getMethods()) {
            XMLCoverageWriter.writeMethod(m, element);
        }
        XMLCoverageWriter.writeCounters((ICoverageNode)c, element);
    }

    private static void writeMethod(IMethodCoverage m, XMLElement parent) throws IOException {
        XMLElement element = XMLCoverageWriter.createChild(parent, "method", m.getName());
        element.attr("desc", m.getDesc());
        int line = m.getFirstLine();
        if (line != -1) {
            element.attr("line", line);
        }
        XMLCoverageWriter.writeCounters((ICoverageNode)m, element);
    }

    private static void writeSourceFile(ISourceFileCoverage s, XMLElement parent) throws IOException {
        XMLElement element = XMLCoverageWriter.createChild(parent, "sourcefile", s.getName());
        XMLCoverageWriter.writeLines((ISourceNode)s, element);
        XMLCoverageWriter.writeCounters((ICoverageNode)s, element);
    }

    public static void writeCounters(ICoverageNode node, XMLElement parent) throws IOException {
        ICoverageNode.CounterEntity[] counterEntityArray = ICoverageNode.CounterEntity.values();
        int n = counterEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICoverageNode.CounterEntity counterEntity = counterEntityArray[n2];
            ICounter counter = node.getCounter(counterEntity);
            if (counter.getTotalCount() > 0) {
                XMLElement counterNode = parent.element("counter");
                counterNode.attr("type", counterEntity.name());
                XMLCoverageWriter.writeCounter(counterNode, "missed", "covered", counter);
                counterNode.close();
            }
            ++n2;
        }
    }

    private static void writeLines(ISourceNode source, XMLElement parent) throws IOException {
        int last = source.getLastLine();
        int nr = source.getFirstLine();
        while (nr <= last) {
            ILine line = source.getLine(nr);
            if (line.getStatus() != 0) {
                XMLElement element = parent.element("line");
                element.attr("nr", nr);
                XMLCoverageWriter.writeCounter(element, "mi", "ci", line.getInstructionCounter());
                XMLCoverageWriter.writeCounter(element, "mb", "cb", line.getBranchCounter());
            }
            ++nr;
        }
    }

    private static void writeCounter(XMLElement element, String missedattr, String coveredattr, ICounter counter) throws IOException {
        element.attr(missedattr, counter.getMissedCount());
        element.attr(coveredattr, counter.getCoveredCount());
    }

    private XMLCoverageWriter() {
    }
}

