/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.memcached.ByteBufPool;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.server.memcached.logging.MemcachedAccessLogging;

public abstract class MemcachedResponse {
    private final CompletionStage<?> response;
    private final Throwable failure;
    protected final Header header;
    private final GenericFutureListener<? extends Future<? super Void>> listener;
    protected int responseBytes = 0;
    private String errorMessage;

    public MemcachedResponse(CompletionStage<?> response, Header header, GenericFutureListener<? extends Future<? super Void>> listener) {
        this(response, null, header, listener);
    }

    public MemcachedResponse(Throwable failure, Header header) {
        this(null, failure, header, null);
    }

    private MemcachedResponse(CompletionStage<?> response, Throwable failure, Header header, GenericFutureListener<? extends Future<? super Void>> listener) {
        this.response = response;
        this.failure = failure;
        this.header = header;
        this.listener = listener;
    }

    public CompletionStage<?> getResponse() {
        return this.response;
    }

    public boolean isSuccessful() {
        return this.failure == null;
    }

    public void writeResponse(Object response, ByteBufPool allocator) {
        if (response != null) {
            this.responseBytes = response instanceof ByteBuf[] ? MemcachedResponse.writeResponse((ByteBuf[])response, allocator) : (response instanceof byte[] ? MemcachedResponse.writeResponse((byte[])response, allocator) : (response instanceof CharSequence ? MemcachedResponse.writeResponse((CharSequence)response, allocator) : MemcachedResponse.writeResponse((ByteBuf)response, allocator)));
        }
    }

    public abstract void writeFailure(Throwable var1, ByteBufPool var2);

    public void writeFailure(ByteBufPool allocator) {
        this.writeFailure(this.failure, allocator);
    }

    protected void useErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void flushed(ChannelFuture future) {
        if (this.header != null) {
            if (this.isSuccessful()) {
                MemcachedAccessLogging.logOK(future, this.header, this.responseBytes);
            } else {
                MemcachedAccessLogging.logException(future, this.header, this.errorMessage, this.errorMessage.length());
            }
        }
        if (this.listener != null) {
            future.addListener(this.listener);
        }
    }

    private static int writeResponse(ByteBuf[] response, ByteBufPool allocator) {
        int size = 0;
        for (ByteBuf buf : response) {
            size += buf.readableBytes();
        }
        ByteBuf output = allocator.acquire(size);
        for (ByteBuf buf : response) {
            output.writeBytes(buf);
        }
        return size;
    }

    private static int writeResponse(byte[] response, ByteBufPool allocator) {
        int size = response.length;
        ByteBuf output = allocator.acquire(size);
        output.writeBytes(response);
        return size;
    }

    private static int writeResponse(CharSequence response, ByteBufPool allocator) {
        int size = response.length();
        ByteBuf output = allocator.acquire(size);
        ByteBufUtil.writeAscii((ByteBuf)output, (CharSequence)response);
        return size;
    }

    private static int writeResponse(ByteBuf response, ByteBufPool allocator) {
        int size = response.readableBytes();
        ByteBuf output = allocator.acquire(size);
        output.writeBytes(response);
        return size;
    }
}

