/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.irac.IracCleanupKeysCommand;
import org.infinispan.commands.irac.IracRequestStateCommand;
import org.infinispan.commands.irac.IracStateResponseCommand;
import org.infinispan.commands.irac.IracTombstoneStateResponseCommand;
import org.infinispan.commands.irac.IracUpdateVersionCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commands.statetransfer.StateTransferCancelCommand;
import org.infinispan.commands.statetransfer.StateTransferStartCommand;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.commands.XSiteAutoTransferStatusCommand;
import org.infinispan.xsite.commands.XSiteBringOnlineCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartSendCommand;
import org.infinispan.xsite.statetransfer.ControlledXSiteStateTransferManager;
import org.infinispan.xsite.statetransfer.StateTransferStatus;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.infinispan.xsite.status.BringSiteOnlineResponse;
import org.infinispan.xsite.status.SiteState;
import org.infinispan.xsite.status.TakeOfflineManager;
import org.infinispan.xsite.status.TakeSiteOfflineResponse;
import org.jgroups.protocols.relay.RELAY2;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.statetransfer.XSiteAutoStateTransferTest")
public class XSiteAutoStateTransferTest
extends AbstractMultipleSitesTest {
    private final int nrKeys = this.defaultNumberOfNodes() * 5;
    private final List<Runnable> cleanupTasks = new CopyOnWriteArrayList<Runnable>();

    public void testSyncStrategyDoNotTriggerStateTransfer() throws InterruptedException {
        String remoteSite = this.siteName(2);
        this.takeSiteOffline(null, remoteSite);
        SiteMasterController controller = this.findSiteMaster(null, new Class[0]);
        controller.getStateTransferManager().startBlockSiteUpEvent();
        XSiteAutoStateTransferTest.triggerSiteUpEvent(controller, remoteSite);
        controller.getStateTransferManager().awaitAndStopBlockingAndAssert(remoteSite).run();
        controller.getRpcManager().expectNoCommand();
        for (int i = 0; i < this.defaultNumberOfNodes(); ++i) {
            TakeOfflineManager manager = this.takeOfflineManager(i, null);
            AssertJUnit.assertSame((Object)SiteState.OFFLINE, (Object)manager.getSiteState(remoteSite));
        }
    }

    public void testManualModeDoNotTriggerStateTransfer() throws InterruptedException {
        String remoteSite = this.siteName(1);
        this.takeSiteOffline(null, remoteSite);
        this.setAutoStateTransferMode(null, remoteSite, XSiteStateTransferMode.MANUAL);
        SiteMasterController controller = this.findSiteMaster(null, new Class[0]);
        controller.getStateTransferManager().startBlockSiteUpEvent();
        XSiteAutoStateTransferTest.triggerSiteUpEvent(controller, remoteSite);
        controller.getStateTransferManager().awaitAndStopBlockingAndAssert(remoteSite).run();
        controller.getRpcManager().expectNoCommand();
        for (int i = 0; i < this.defaultNumberOfNodes(); ++i) {
            TakeOfflineManager manager = this.takeOfflineManager(i, null);
            AssertJUnit.assertSame((Object)SiteState.OFFLINE, (Object)manager.getSiteState(remoteSite));
        }
    }

    public void testSingleManualModeDoNotTriggerStateTransfer() throws InterruptedException, TimeoutException, ExecutionException {
        String remoteSite = this.siteName(1);
        this.takeSiteOffline(null, remoteSite);
        this.setAutoStateTransferMode(null, remoteSite, XSiteStateTransferMode.AUTO);
        SiteMasterController controller = this.findSiteMaster(null, new Class[0]);
        this.stateTransferManager((controller.managerIndex + 1) % this.defaultNumberOfNodes(), null).setAutomaticStateTransfer(remoteSite, XSiteStateTransferMode.MANUAL);
        controller.getStateTransferManager().startBlockSiteUpEvent();
        XSiteAutoStateTransferTest.triggerSiteUpEvent(controller, remoteSite);
        Runnable continueEvent = controller.getStateTransferManager().awaitAndStopBlockingAndAssert(remoteSite);
        CompletableFuture<ControlledRpcManager.BlockedRequest<XSiteAutoTransferStatusCommand>> req = controller.getRpcManager().expectCommandAsync(XSiteAutoTransferStatusCommand.class);
        continueEvent.run();
        ControlledRpcManager.BlockedRequest<XSiteAutoTransferStatusCommand> cmd = req.get(30L, TimeUnit.SECONDS);
        cmd.send().receiveAll();
        for (int i = 0; i < this.defaultNumberOfNodes(); ++i) {
            TakeOfflineManager manager = this.takeOfflineManager(i, null);
            AssertJUnit.assertSame((Object)SiteState.OFFLINE, (Object)manager.getSiteState(remoteSite));
        }
    }

    public void testAutoStateTransfer(Method method) throws InterruptedException, TimeoutException, ExecutionException {
        String remoteSite = this.siteName(1);
        this.takeSiteOffline(null, remoteSite);
        this.takeSiteOffline(null, this.siteName(2));
        this.setAutoStateTransferMode(null, remoteSite, XSiteStateTransferMode.AUTO);
        this.insertDataInSite0(method, null);
        this.checkNoDataInSite1(method, null);
        SiteMasterController controller = this.findSiteMaster(null, XSiteStatePushCommand.class, IracCleanupKeysCommand.class, IracTombstoneStateResponseCommand.class, StateTransferCancelCommand.class);
        CompletableFuture<ControlledRpcManager.BlockedRequest<XSiteAutoTransferStatusCommand>> req1 = controller.getRpcManager().expectCommandAsync(XSiteAutoTransferStatusCommand.class);
        CompletableFuture<ControlledRpcManager.BlockedRequest<XSiteBringOnlineCommand>> req2 = controller.getRpcManager().expectCommandAsync(XSiteBringOnlineCommand.class);
        CompletableFuture<ControlledRpcManager.BlockedRequest<XSiteStateTransferStartSendCommand>> req3 = controller.getRpcManager().expectCommandAsync(XSiteStateTransferStartSendCommand.class);
        controller.getStateTransferManager().startBlockSiteUpEvent();
        XSiteAutoStateTransferTest.triggerSiteUpEvent(controller, remoteSite);
        controller.getStateTransferManager().awaitAndStopBlockingAndAssert(remoteSite).run();
        req1.get(10L, TimeUnit.SECONDS).send().receiveAll();
        req2.get(10L, TimeUnit.SECONDS).send().receiveAll();
        req3.get(10L, TimeUnit.SECONDS).send().receiveAll();
        controller.getRpcManager().stopBlocking();
        for (int i = 0; i < this.defaultNumberOfNodes(); ++i) {
            TakeOfflineManager manager = this.takeOfflineManager(i, null);
            AssertJUnit.assertSame((Object)SiteState.ONLINE, (Object)manager.getSiteState(remoteSite));
            AssertJUnit.assertSame((Object)SiteState.OFFLINE, (Object)manager.getSiteState(this.siteName(2)));
        }
        this.eventuallyEquals(StateTransferStatus.SEND_OK, () -> controller.getStateTransferManager().getStatus().get(remoteSite));
        this.checkDataInSite0And1(method, null);
    }

    public void testNewSiteMasterStartsStateTransfer(Method method) throws Exception {
        String remoteSite = this.siteName(1);
        this.takeSiteOffline(null, remoteSite);
        this.takeSiteOffline(null, this.siteName(2));
        this.setAutoStateTransferMode(null, remoteSite, XSiteStateTransferMode.AUTO);
        this.insertDataInSite0(method, null);
        this.checkNoDataInSite1(method, null);
        SiteMasterController oldSiteMaster = this.findSiteMaster(null, new Class[0]);
        SiteMasterController newSiteMaster = this.getSiteMasterController(oldSiteMaster.managerIndex + 1 % this.defaultNumberOfNodes(), XSiteStatePushCommand.class, StateTransferStartCommand.class, StateResponseCommand.class, StateTransferCancelCommand.class, IracRequestStateCommand.class, IracStateResponseCommand.class, IracUpdateVersionCommand.class, IracCleanupKeysCommand.class, IracTombstoneStateResponseCommand.class);
        oldSiteMaster.getRpcManager().stopBlocking();
        CompletableFuture<ControlledRpcManager.BlockedRequest<XSiteAutoTransferStatusCommand>> req1 = newSiteMaster.getRpcManager().expectCommandAsync(XSiteAutoTransferStatusCommand.class);
        CompletableFuture<ControlledRpcManager.BlockedRequest<XSiteBringOnlineCommand>> req3 = newSiteMaster.getRpcManager().expectCommandAsync(XSiteBringOnlineCommand.class);
        CompletableFuture<ControlledRpcManager.BlockedRequest<XSiteStateTransferStartSendCommand>> req4 = newSiteMaster.getRpcManager().expectCommandAsync(XSiteStateTransferStartSendCommand.class);
        newSiteMaster.getStateTransferManager().startBlockSiteUpEvent();
        this.site(0).kill(0);
        this.site(0).waitForClusterToForm(null);
        newSiteMaster.getStateTransferManager().awaitAndStopBlockingAndAssert(this.siteName(1), this.siteName(2)).run();
        req1.get(10L, TimeUnit.SECONDS).send().receiveAll();
        req3.get(10L, TimeUnit.SECONDS).send().receiveAll();
        req4.get(10L, TimeUnit.SECONDS).send().receiveAll();
        newSiteMaster.getRpcManager().stopBlocking();
        for (int i = 0; i < this.defaultNumberOfNodes() - 1; ++i) {
            TakeOfflineManager manager = this.takeOfflineManager(i, null);
            AssertJUnit.assertSame((Object)SiteState.ONLINE, (Object)manager.getSiteState(remoteSite));
            AssertJUnit.assertSame((Object)SiteState.OFFLINE, (Object)manager.getSiteState(this.siteName(2)));
        }
        this.eventuallyEquals(StateTransferStatus.SEND_OK, () -> newSiteMaster.getStateTransferManager().getStatus().get(remoteSite));
        this.checkDataInSite0And1(method, null);
    }

    public void testInitialStateTransferDuringCacheStart(Method method) throws InterruptedException {
        String remoteSite = this.siteName(1);
        String cacheName = "initial-state-transfer-1";
        this.createCache(0, "initial-state-transfer-1");
        this.takeSiteOffline("initial-state-transfer-1", remoteSite);
        this.takeSiteOffline("initial-state-transfer-1", this.siteName(2));
        this.setAutoStateTransferMode("initial-state-transfer-1", remoteSite, XSiteStateTransferMode.AUTO);
        this.insertDataInSite0(method, "initial-state-transfer-1");
        this.bringSiteOnline("initial-state-transfer-1", remoteSite);
        SiteMasterController siteMasterController = this.findSiteMaster("initial-state-transfer-1", new Class[0]);
        siteMasterController.getStateTransferManager().startBlockSiteUpEvent();
        siteMasterController.getRpcManager().stopBlocking();
        this.createCache(1, "initial-state-transfer-1");
        this.checkNoDataInSite1(method, "initial-state-transfer-1");
        siteMasterController.getStateTransferManager().awaitAndStopBlockingAndAssert(remoteSite).run();
        this.eventuallyEquals(StateTransferStatus.SEND_OK, () -> siteMasterController.getStateTransferManager().getStatus().get(remoteSite));
        this.checkDataInSite0And1(method, "initial-state-transfer-1");
    }

    public void testInitialStateTransferDoesNotStartWithManual(Method method) throws InterruptedException, ExecutionException, TimeoutException {
        String remoteSite = this.siteName(1);
        String cacheName = "initial-state-transfer-2";
        this.createCache(0, "initial-state-transfer-2");
        this.takeSiteOffline("initial-state-transfer-2", remoteSite);
        this.takeSiteOffline("initial-state-transfer-2", this.siteName(2));
        this.setAutoStateTransferMode("initial-state-transfer-2", remoteSite, XSiteStateTransferMode.AUTO);
        this.insertDataInSite0(method, "initial-state-transfer-2");
        this.bringSiteOnline("initial-state-transfer-2", remoteSite);
        SiteMasterController siteMasterController = this.findSiteMaster("initial-state-transfer-2", new Class[0]);
        siteMasterController.getStateTransferManager().startBlockSiteUpEvent();
        this.stateTransferManager((siteMasterController.managerIndex + 1) % this.defaultNumberOfSites(), "initial-state-transfer-2").setAutomaticStateTransfer(remoteSite, XSiteStateTransferMode.MANUAL);
        this.createCache(1, "initial-state-transfer-2");
        this.checkNoDataInSite1(method, "initial-state-transfer-2");
        CompletableFuture<ControlledRpcManager.BlockedRequest<XSiteAutoTransferStatusCommand>> req = siteMasterController.getRpcManager().expectCommandAsync(XSiteAutoTransferStatusCommand.class);
        siteMasterController.getStateTransferManager().awaitAndStopBlockingAndAssert(remoteSite).run();
        req.get(30L, TimeUnit.SECONDS).send().receiveAll();
        this.checkNoDataInSite1(method, "initial-state-transfer-2");
    }

    @Override
    protected int defaultNumberOfSites() {
        return 3;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 3;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = super.defaultConfigurationForSite(siteIndex);
        builder.clustering().hash().numSegments(21);
        if (siteIndex == 0) {
            builder.sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.ASYNC).sites().addBackup().site(this.siteName(2)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        } else if (siteIndex == 1) {
            builder.sites().addBackup().site(this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.ASYNC).sites().addBackup().site(this.siteName(2)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        } else {
            builder.sites().addBackup().site(this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.ASYNC).sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        }
        return builder;
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        this.cleanupTasks.forEach(Runnable::run);
        this.cleanupTasks.clear();
        while (this.site(0).cacheManagers().size() < this.defaultNumberOfNodes()) {
            this.site(0).addCacheManager(null, this.defaultGlobalConfigurationForSite(0), this.defaultConfigurationForSite(0), false);
        }
        this.site(0).waitForClusterToForm(null);
        super.clearContent();
    }

    private void createCache(int siteIdx, String cacheName) {
        ((EmbeddedCacheManagerAdmin)this.manager(siteIdx, 0).administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache(cacheName, this.defaultConfigurationForSite(siteIdx).build());
        this.site(siteIdx).waitForClusterToForm(cacheName);
    }

    private void insertDataInSite0(Method method, String cacheName) {
        for (int i = 0; i < this.nrKeys; ++i) {
            this.cache(0, 0, cacheName).put((Object)TestingUtil.k(method, i), (Object)TestingUtil.v(method, i));
        }
    }

    private void checkNoDataInSite1(Method method, String cacheName) {
        for (int i = 0; i < this.nrKeys; ++i) {
            AssertJUnit.assertNull((Object)this.cache(1, 0, cacheName).get((Object)TestingUtil.k(method, i)));
        }
    }

    private void checkDataInSite0And1(Method method, String cacheName) {
        for (int i = 0; i < this.nrKeys; ++i) {
            String key = TestingUtil.k(method, i);
            String value = TestingUtil.v(method, i);
            AssertJUnit.assertEquals((Object)value, (Object)this.cache(0, 0, cacheName).get((Object)key));
            AssertJUnit.assertEquals((Object)value, (Object)this.cache(1, 0, cacheName).get((Object)key));
        }
    }

    private void takeSiteOffline(String cacheName, String remoteSite) {
        for (int i = 0; i < this.defaultNumberOfNodes(); ++i) {
            TakeOfflineManager manager = this.takeOfflineManager(i, cacheName);
            AssertJUnit.assertNotSame((Object)TakeSiteOfflineResponse.NO_SUCH_SITE, (Object)manager.takeSiteOffline(remoteSite));
            AssertJUnit.assertEquals((Object)SiteState.OFFLINE, (Object)manager.getSiteState(remoteSite));
        }
    }

    private void bringSiteOnline(String cacheName, String remoteSite) {
        for (int i = 0; i < this.defaultNumberOfNodes(); ++i) {
            TakeOfflineManager manager = this.takeOfflineManager(i, cacheName);
            AssertJUnit.assertNotSame((Object)BringSiteOnlineResponse.NO_SUCH_SITE, (Object)manager.bringSiteOnline(remoteSite));
            AssertJUnit.assertEquals((Object)SiteState.ONLINE, (Object)manager.getSiteState(remoteSite));
        }
    }

    private void setAutoStateTransferMode(String cacheName, String remoteSite, XSiteStateTransferMode mode) {
        for (int i = 0; i < this.defaultNumberOfNodes(); ++i) {
            XSiteStateTransferManager manager = this.stateTransferManager(i, cacheName);
            manager.setAutomaticStateTransfer(remoteSite, mode);
            AssertJUnit.assertEquals((Object)mode, (Object)manager.stateTransferMode(remoteSite));
        }
    }

    private TakeOfflineManager takeOfflineManager(int managerIndex, String cacheName) {
        return TestingUtil.extractComponent(this.cache(0, managerIndex, cacheName), TakeOfflineManager.class);
    }

    @SafeVarargs
    private SiteMasterController findSiteMaster(String cacheName, Class<? extends CacheRpcCommand> ... excludedCommands) {
        for (int i = 0; i < this.defaultNumberOfNodes(); ++i) {
            EmbeddedCacheManager manager = this.manager(0, i);
            Optional<RELAY2> relay2 = XSiteAutoStateTransferTest.findRelay2(manager);
            if (!relay2.isPresent() || !relay2.get().isSiteMaster()) continue;
            AssertJUnit.assertTrue((boolean)TestingUtil.extractGlobalComponent((CacheContainer)manager, Transport.class).isCoordinator());
            Cache cache = cacheName == null ? manager.getCache() : manager.getCache(cacheName);
            ControlledRpcManager rpcManager = ControlledRpcManager.replaceRpcManager(cache, excludedCommands);
            rpcManager.addExcludedCommand(IracCleanupKeysCommand.class);
            ControlledXSiteStateTransferManager stateTransferManager = ControlledXSiteStateTransferManager.extract(cache);
            this.cleanupTasks.add(() -> {
                try {
                    rpcManager.revertRpcManager();
                    ControlledXSiteStateTransferManager.revertXsiteStateTransferManager(cache);
                }
                catch (IllegalLifecycleStateException e) {
                    log.debug((Object)"Ignored exception during cleanup", (Throwable)e);
                }
            });
            return new SiteMasterController(relay2.get(), stateTransferManager, rpcManager, i);
        }
        throw new IllegalStateException();
    }

    private static void triggerSiteUpEvent(SiteMasterController controller, String site) {
        controller.getRelay2().getRouteStatusListener().sitesUp(new String[]{site});
    }

    private static Optional<RELAY2> findRelay2(EmbeddedCacheManager manager) {
        return Optional.ofNullable((RELAY2)TestingUtil.extractJChannel(manager).getProtocolStack().findProtocol(RELAY2.class));
    }

    private XSiteStateTransferManager stateTransferManager(int managerIndex, String cacheName) {
        return TestingUtil.extractComponent(this.cache(0, managerIndex, cacheName), XSiteStateTransferManager.class);
    }

    @SafeVarargs
    private SiteMasterController getSiteMasterController(int index, Class<? extends CacheRpcCommand> ... excludedCommands) {
        EmbeddedCacheManager manager = this.manager(0, index);
        Optional<RELAY2> relay2 = XSiteAutoStateTransferTest.findRelay2(manager);
        if (relay2.isPresent()) {
            ControlledRpcManager rpcManager = ControlledRpcManager.replaceRpcManager(manager.getCache(), excludedCommands);
            ControlledXSiteStateTransferManager stateTransferManager = ControlledXSiteStateTransferManager.extract(manager.getCache());
            this.cleanupTasks.add(() -> {
                try {
                    rpcManager.revertRpcManager();
                    ControlledXSiteStateTransferManager.revertXsiteStateTransferManager(manager.getCache());
                }
                catch (IllegalLifecycleStateException e) {
                    log.debug((Object)"Ignored exception during cleanup", (Throwable)e);
                }
            });
            return new SiteMasterController(relay2.get(), stateTransferManager, rpcManager, index);
        }
        throw new IllegalStateException();
    }

    private static class SiteMasterController {
        private final RELAY2 relay2;
        private final ControlledXSiteStateTransferManager stateTransferManager;
        private final ControlledRpcManager rpcManager;
        private final int managerIndex;

        private SiteMasterController(RELAY2 relay2, ControlledXSiteStateTransferManager stateTransferManager, ControlledRpcManager rpcManager, int managerIndex) {
            this.relay2 = relay2;
            this.stateTransferManager = stateTransferManager;
            this.rpcManager = rpcManager;
            this.managerIndex = managerIndex;
        }

        RELAY2 getRelay2() {
            return this.relay2;
        }

        ControlledXSiteStateTransferManager getStateTransferManager() {
            return this.stateTransferManager;
        }

        ControlledRpcManager getRpcManager() {
            return this.rpcManager;
        }
    }
}

