/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac.persistence;

import java.lang.reflect.Method;
import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="irac.persistence.IracAsyncStoreTest")
public class IracAsyncStoreTest
extends AbstractMultipleSitesTest {
    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = super.defaultConfigurationForSite(siteIndex);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName("site-" + siteIndex).shared(true)).async().enable();
        builder.sites().addBackup().site(siteIndex == 0 ? this.siteName(1) : this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        builder.clustering().hash().numSegments(16);
        return builder;
    }

    public void testWrite(Method method) {
        String key = TestingUtil.k(method);
        this.cache(0, 0).put((Object)key, (Object)"value");
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals("value", cache.get((Object)key)));
        this.eventuallyAssertInAllSitesAndCaches(cache -> IracAsyncStoreTest.storeForCache(cache).contains(key));
    }

    public void testRemove(Method method) {
        String key = TestingUtil.k(method);
        this.cache(0, 0).put((Object)key, (Object)"value");
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals("value", cache.get((Object)key)));
        this.eventuallyAssertInAllSitesAndCaches(cache -> IracAsyncStoreTest.storeForCache(cache).contains(key));
        this.cache(0, 0).remove((Object)key);
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.isNull(cache.get((Object)key)));
        this.eventuallyAssertInAllSitesAndCaches(cache -> !IracAsyncStoreTest.storeForCache(cache).contains(key));
    }

    private static <K, V> WaitDelegatingNonBlockingStore<K, V> storeForCache(Cache<K, V> cache) {
        return TestingUtil.getFirstStoreWait(cache);
    }
}

