/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.LockingMode;
import org.infinispan.xsite.AbstractXSiteTest;
import org.testng.AssertJUnit;

public abstract class AbstractTwoSitesTest
extends AbstractXSiteTest {
    protected static final String LON = "LON-1";
    protected static final String NYC = "NYC-2";
    protected BackupFailurePolicy lonBackupFailurePolicy = BackupFailurePolicy.WARN;
    protected boolean isLonBackupTransactional = false;
    protected BackupConfiguration.BackupStrategy lonBackupStrategy = BackupConfiguration.BackupStrategy.SYNC;
    protected BackupConfiguration.BackupStrategy nycBackupStrategy = BackupConfiguration.BackupStrategy.SYNC;
    protected String lonCustomFailurePolicyClass = null;
    protected boolean use2Pc = false;
    protected int initialClusterSize = 2;
    protected boolean implicitBackupCache = false;
    protected CacheMode cacheMode;
    protected boolean transactional;
    protected LockingMode lockingMode;

    @Override
    protected void createSites() {
        ConfigurationBuilder lon = this.lonConfigurationBuilder();
        ConfigurationBuilder nyc = this.getNycActiveConfig();
        nyc.sites().addBackup().site(LON).strategy(this.nycBackupStrategy);
        nyc.sites().addBackup().site(NYC).strategy(this.nycBackupStrategy);
        this.createSite(LON, this.initialClusterSize, this.globalConfigurationBuilderForSite(LON), lon);
        this.createSite(NYC, this.initialClusterSize, this.globalConfigurationBuilderForSite(NYC), nyc);
        if (!this.implicitBackupCache) {
            ConfigurationBuilder nycBackup = AbstractTwoSitesTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
            nycBackup.sites().backupFor().remoteSite(NYC).remoteCache(this.getDefaultCacheName());
            this.startCache(LON, "nycBackup", nycBackup);
            ConfigurationBuilder lonBackup = AbstractTwoSitesTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, this.isLonBackupTransactional);
            lonBackup.sites().backupFor().remoteSite(LON).remoteCache(this.getDefaultCacheName());
            this.startCache(NYC, "lonBackup", lonBackup);
            Configuration lonBackupConfig = this.cache(NYC, "lonBackup", 0).getCacheConfiguration();
            AssertJUnit.assertTrue((boolean)lonBackupConfig.sites().backupFor().isBackupFor(LON, this.getDefaultCacheName()));
        }
        this.waitForSites(LON, NYC);
    }

    protected ConfigurationBuilder lonConfigurationBuilder() {
        ConfigurationBuilder lon = this.getLonActiveConfig();
        BackupConfigurationBuilder lonBackupConfigurationBuilder = lon.sites().addBackup();
        lonBackupConfigurationBuilder.site(NYC).backupFailurePolicy(this.lonBackupFailurePolicy).strategy(this.lonBackupStrategy).failurePolicyClass(this.lonCustomFailurePolicyClass).useTwoPhaseCommit(this.use2Pc).stateTransfer().maxRetries(1).waitTime(500L);
        this.adaptLONConfiguration(lonBackupConfigurationBuilder);
        lon.sites().addBackup().site(LON).strategy(this.lonBackupStrategy);
        return lon;
    }

    protected GlobalConfigurationBuilder globalConfigurationBuilderForSite(String siteName) {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        return builder;
    }

    protected void adaptLONConfiguration(BackupConfigurationBuilder builder) {
    }

    protected Cache<Object, Object> backup(String site) {
        return this.backup(site, 0);
    }

    protected Cache<Object, Object> backup(String site, int offset) {
        if (site.equals(LON)) {
            return this.implicitBackupCache ? this.cache(NYC, offset) : this.cache(NYC, "lonBackup", offset);
        }
        if (site.equals(NYC)) {
            return this.implicitBackupCache ? this.cache(LON, offset) : this.cache(LON, "nycBackup", offset);
        }
        throw new IllegalArgumentException("No such site: " + site);
    }

    protected String val(String site) {
        return "v_" + site;
    }

    protected String key(String site) {
        return "k_" + site;
    }

    public AbstractTwoSitesTest cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public AbstractTwoSitesTest transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public AbstractTwoSitesTest lockingMode(LockingMode lockingMode) {
        this.lockingMode = lockingMode;
        return this;
    }

    public AbstractTwoSitesTest use2Pc(boolean use2Pc) {
        this.use2Pc = use2Pc;
        return this;
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{null, "tx", "lockingMode", null};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.cacheMode, this.transactional, this.lockingMode, this.use2Pc ? "2PC" : null};
    }

    protected abstract ConfigurationBuilder getNycActiveConfig();

    protected abstract ConfigurationBuilder getLonActiveConfig();
}

