/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.tx.locking.AbstractLocalTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.locking.LocalPessimisticTxTest")
public class LocalPessimisticTxTest
extends AbstractLocalTest {
    public void testLockingWithRollback() throws Exception {
        this.tm().begin();
        this.cache().getAdvancedCache().lock(new Object[]{"k"});
        this.assertLockingOnRollback();
        Assert.assertNull((Object)this.cache().get((Object)"k"));
        this.tm().begin();
        this.cache().getAdvancedCache().lock(new Object[]{"k"});
        this.cache().put((Object)"k", (Object)"v");
        this.assertLockingOnRollback();
        Assert.assertNull((Object)this.cache().get((Object)"k"));
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder config = this.getDefaultStandaloneCacheConfig(true);
        config.transaction().lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(false).recovery().disable();
        return TestCacheManagerFactory.createCacheManager(config);
    }

    @Override
    protected void assertLockingOnRollback() {
        Assert.assertTrue((boolean)this.lockManager().isLocked((Object)"k"));
        this.rollback();
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
    }

    @Override
    protected void assertLocking() {
        Assert.assertTrue((boolean)this.lockManager().isLocked((Object)"k"));
        this.commit();
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
    }
}

