/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TxCompletionForRolledBackTxTest")
public class TxCompletionForRolledBackTxTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = TxCompletionForRolledBackTxTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.clustering().hash().numOwners(1).transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.amend(dcc);
        this.createCluster(TestDataSCI.INSTANCE, dcc, 2);
        this.waitForClusterToForm();
    }

    protected void amend(ConfigurationBuilder dcc) {
    }

    public void testTxCompletionNotSentForRollback() throws Throwable {
        ControlledCommandFactory cf = ControlledCommandFactory.registerControlledCommandFactory(this.cache(1), null);
        this.tm(0).begin();
        Object k = this.getKeyForCache(1);
        this.cache(0).put(k, (Object)"k");
        this.tm(0).rollback();
        this.assertNotLocked(k);
        Assert.assertNull((Object)this.cache(0).get(k));
        Assert.assertEquals((int)cf.received(RollbackCommand.class), (int)1);
        Assert.assertEquals((int)cf.received(TxCompletionNotificationCommand.class), (int)0);
    }
}

