/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.DefaultEnlistmentModeTest")
public class DefaultEnlistmentModeTest
extends AbstractCacheTest {
    private EmbeddedCacheManager ecm;

    @AfterMethod
    protected void destroyCacheManager() {
        TestingUtil.killCacheManagers(this.ecm);
    }

    public void testDefaultEnlistment() {
        ConfigurationBuilder builder = this.getLocalBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.ecm = TestCacheManagerFactory.createCacheManager(builder);
        Cache cache = this.ecm.getCache();
        AssertJUnit.assertFalse((boolean)cache.getCacheConfiguration().transaction().useSynchronization());
        AssertJUnit.assertFalse((boolean)cache.getCacheConfiguration().transaction().recovery().enabled());
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
    }

    public void testXAEnlistment() {
        ConfigurationBuilder builder = this.getLocalBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(false);
        this.ecm = TestCacheManagerFactory.createCacheManager(builder);
        Cache cache = this.ecm.getCache();
        AssertJUnit.assertFalse((boolean)cache.getCacheConfiguration().transaction().useSynchronization());
        AssertJUnit.assertFalse((boolean)cache.getCacheConfiguration().transaction().recovery().enabled());
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
    }

    public void testXAEnlistmentNoRecovery() {
        ConfigurationBuilder builder = this.getLocalBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(false).recovery().disable();
        this.ecm = TestCacheManagerFactory.createCacheManager(builder);
        Cache cache = this.ecm.getCache();
        AssertJUnit.assertFalse((boolean)cache.getCacheConfiguration().transaction().useSynchronization());
        AssertJUnit.assertFalse((boolean)cache.getCacheConfiguration().transaction().recovery().enabled());
    }

    private ConfigurationBuilder getLocalBuilder() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        return builder;
    }
}

