/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.Arrays;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.context.Flag;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.stats.Stats;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.SingleStatsTest")
public class SingleStatsTest
extends MultipleCacheManagersTest {
    private static final int OFF_HEAP_KEY_SIZE = 6;
    private static final int OFF_HEAP_VALUE_SIZE = 8;
    private long OFF_HEAP_SIZE = -1L;
    protected final int EVICTION_MAX_ENTRIES = 3;
    protected final int TOTAL_ENTRIES = 5;
    protected StorageType storageType;
    protected boolean countBasedEviction;
    protected boolean accurateSize = true;
    protected EvictionStrategy evictionStrategy = EvictionStrategy.REMOVE;
    protected Cache<String, String> cache;
    protected Stats stats;

    @Override
    public Object[] factory() {
        return Arrays.stream(EvictionStrategy.values()).filter(EvictionStrategy::isEnabled).flatMap(strategy -> Arrays.stream(new Object[]{new SingleStatsTest().withStorage(StorageType.BINARY).withCountEviction(false).withEvictionStrategy((EvictionStrategy)strategy), new SingleStatsTest().withStorage(StorageType.BINARY).withCountEviction(true).withEvictionStrategy((EvictionStrategy)strategy), new SingleStatsTest().withStorage(StorageType.BINARY).withCountEviction(true).withEvictionStrategy((EvictionStrategy)strategy).withAccurateSize(false), new SingleStatsTest().withStorage(StorageType.HEAP).withCountEviction(true).withEvictionStrategy((EvictionStrategy)strategy), new SingleStatsTest().withStorage(StorageType.HEAP).withCountEviction(true).withEvictionStrategy((EvictionStrategy)strategy).withAccurateSize(false), new SingleStatsTest().withStorage(StorageType.OFF_HEAP).withCountEviction(true).withEvictionStrategy((EvictionStrategy)strategy), new SingleStatsTest().withStorage(StorageType.OFF_HEAP).withCountEviction(false).withEvictionStrategy((EvictionStrategy)strategy), new SingleStatsTest().withStorage(StorageType.OFF_HEAP).withCountEviction(false).withEvictionStrategy((EvictionStrategy)strategy).withAccurateSize(false)})).toArray();
    }

    @Override
    protected String[] parameterNames() {
        return SingleStatsTest.concat(super.parameterNames(), "StorageType", "CountBasedEviction", "EvictionStrategy", "AccurateSize");
    }

    @Override
    protected Object[] parameterValues() {
        return SingleStatsTest.concat(super.parameterValues(), this.storageType, this.countBasedEviction, this.evictionStrategy, this.accurateSize);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = SingleStatsTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        this.configure(cfg);
        GlobalConfigurationBuilder global = this.defaultGlobalConfigurationBuilder();
        global.metrics().accurateSize(this.accurateSize);
        this.addClusterEnabledCacheManager(global, cfg);
        this.cache = this.cache(0);
        this.refreshStats();
    }

    protected void configure(ConfigurationBuilder cfg) {
        long size = 3L;
        MemoryConfigurationBuilder memoryConfigurationBuilder = cfg.memory();
        memoryConfigurationBuilder.storage(this.storageType);
        if (this.countBasedEviction) {
            memoryConfigurationBuilder.maxCount(size);
        } else {
            if (this.storageType == StorageType.OFF_HEAP) {
                long amountPerEntry = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)(this.OFF_HEAP_SIZE + (long)(this.evictionStrategy.isExceptionBased() ? 19 : 0)));
                size *= amountPerEntry;
                size += UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)2048L);
            } else {
                size *= (long)(128 + (this.evictionStrategy.isExceptionBased() ? 48 : 0));
            }
            memoryConfigurationBuilder.maxSize(Long.toString(size));
        }
        memoryConfigurationBuilder.whenFull(this.evictionStrategy);
        if (this.evictionStrategy == EvictionStrategy.EXCEPTION) {
            cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        ((DummyInMemoryStoreConfigurationBuilder)cfg.statistics().enable().persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).purgeOnStartup(true);
    }

    public SingleStatsTest withStorage(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public SingleStatsTest withCountEviction(boolean countBasedEviction) {
        this.countBasedEviction = countBasedEviction;
        return this;
    }

    public SingleStatsTest withEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.evictionStrategy = evictionStrategy;
        this.OFF_HEAP_SIZE = UnpooledOffHeapMemoryAllocator.offHeapEntrySize((evictionStrategy == EvictionStrategy.REMOVE ? 1 : 0) != 0, (boolean)false, (int)6, (int)8);
        return this;
    }

    public SingleStatsTest withAccurateSize(boolean accurateSize) {
        this.accurateSize = accurateSize;
        return this;
    }

    @AfterMethod
    public void cleanCache() {
        this.cache.clear();
        this.cache.getAdvancedCache().getStats().reset();
    }

    public void testStats() {
        this.refreshStats();
        if (this.accurateSize) {
            AssertJUnit.assertEquals((int)0, (int)this.stats.getCurrentNumberOfEntries());
        } else {
            AssertJUnit.assertEquals((int)-1, (int)this.stats.getCurrentNumberOfEntries());
        }
        int insertErrors = 0;
        for (int i = 0; i < 5; ++i) {
            try {
                this.cache.put((Object)("key" + i), (Object)("value" + i));
                continue;
            }
            catch (CacheException e) {
                ++insertErrors;
            }
        }
        if (insertErrors > 0 && 2 != insertErrors) {
            AssertJUnit.fail((String)("Number of failed errors was: " + insertErrors + " manually check them."));
        }
        DataOperationOrderer doo = TestingUtil.extractComponent(this.cache, DataOperationOrderer.class);
        SingleStatsTest.eventually(() -> doo.pendingOperations() == 0);
        int expectedSize = 5 - insertErrors;
        this.refreshStats();
        AssertJUnit.assertEquals((long)expectedSize, (long)this.stats.getApproximateEntries());
        AssertJUnit.assertEquals((long)3L, (long)this.stats.getApproximateEntriesInMemory());
        AssertJUnit.assertEquals((long)this.primaryKeysCount(this.cache), (long)this.stats.getApproximateEntriesUnique());
        if (this.accurateSize) {
            AssertJUnit.assertEquals((int)expectedSize, (int)this.stats.getCurrentNumberOfEntries());
            AssertJUnit.assertEquals((int)3, (int)this.stats.getCurrentNumberOfEntriesInMemory());
        } else {
            AssertJUnit.assertEquals((int)-1, (int)this.stats.getCurrentNumberOfEntries());
            AssertJUnit.assertEquals((int)-1, (int)this.stats.getCurrentNumberOfEntriesInMemory());
        }
        this.eventuallyEquals((long)expectedSize - 3L, () -> {
            this.refreshStats();
            return this.stats.getEvictions();
        });
        int additionalMisses = 0;
        for (int i = 0; i < expectedSize; ++i) {
            String key;
            AdvancedCache skipLoaderCache = this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
            if (skipLoaderCache.containsKey((Object)(key = "key" + i))) {
                this.cache.evict((Object)key);
                break;
            }
            ++additionalMisses;
        }
        this.refreshStats();
        AssertJUnit.assertEquals((long)(expectedSize - 3 + 1), (long)this.stats.getEvictions());
        AssertJUnit.assertEquals((String)"value1", (String)((String)this.cache.get((Object)"key1")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)this.cache.get((Object)"key2")));
        AssertJUnit.assertEquals((String)"value1", (String)((String)this.cache.remove((Object)"key1")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)this.cache.remove((Object)"key2")));
        AssertJUnit.assertNull((Object)this.cache.remove((Object)"non-existing"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key1"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key2"));
        this.refreshStats();
        AssertJUnit.assertEquals((long)3L, (long)this.stats.getHits());
        AssertJUnit.assertEquals((long)(2 + additionalMisses), (long)this.stats.getMisses());
        AssertJUnit.assertEquals((long)2L, (long)this.stats.getRemoveHits());
        AssertJUnit.assertEquals((long)1L, (long)this.stats.getRemoveMisses());
        AssertJUnit.assertEquals((long)(5 + additionalMisses), (long)this.stats.getRetrievals());
        AssertJUnit.assertEquals((long)5L, (long)this.stats.getStores());
        this.cache.put((Object)"other-key", (Object)"value");
        this.refreshStats();
        AssertJUnit.assertEquals((long)6L, (long)this.stats.getStores());
        AssertJUnit.assertTrue((this.stats.getAverageReadTime() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageRemoveTime() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageWriteTime() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageReadTimeNanos() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageRemoveTimeNanos() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageWriteTimeNanos() >= 0L ? 1 : 0) != 0);
        if (this.countBasedEviction || this.evictionStrategy.isExceptionBased()) {
            AssertJUnit.assertEquals((long)-1L, (long)this.stats.getDataMemoryUsed());
        } else {
            AssertJUnit.assertTrue((this.stats.getDataMemoryUsed() > 0L ? 1 : 0) != 0);
        }
        if (this.storageType == StorageType.OFF_HEAP) {
            AssertJUnit.assertTrue((this.stats.getOffHeapMemoryUsed() > 0L ? 1 : 0) != 0);
        }
    }

    protected long primaryKeysCount(Cache<?, ?> cache) {
        return this.evictionStrategy == EvictionStrategy.EXCEPTION ? 3L : 5L;
    }

    protected void refreshStats() {
        this.stats = this.cache.getAdvancedCache().getStats();
    }
}

