/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.topology.ClusterTopologyManager;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.PerCacheRebalancePolicyJmxTest")
@CleanupAfterMethod
@InCacheMode(value={CacheMode.DIST_SYNC})
public class PerCacheRebalancePolicyJmxTest
extends MultipleCacheManagersTest {
    private static final String REBALANCING_ENABLED = "rebalancingEnabled";
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    public void testJoinAndLeaveWithRebalanceSuspended() throws Exception {
        this.doTest(false);
    }

    public void testJoinAndLeaveWithRebalanceSuspendedAwaitingInitialTransfer() throws Exception {
        this.doTest(true);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    private ConfigurationBuilder getConfigurationBuilder(boolean awaitInitialTransfer) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(this.cacheMode).stateTransfer().awaitInitialTransfer(awaitInitialTransfer);
        return cb;
    }

    private GlobalConfigurationBuilder getGlobalConfigurationBuilder(String rackId) {
        int index = this.cacheManagers.size();
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.transport().rackId(rackId);
        TestCacheManagerFactory.configureJmx(gcb, this.getClass().getSimpleName() + index, this.mBeanServerLookup);
        return gcb;
    }

    private void addNode(GlobalConfigurationBuilder gcb, ConfigurationBuilder builder) {
        EmbeddedCacheManager cacheManager = this.addClusterEnabledCacheManager(gcb, builder);
        cacheManager.defineConfiguration("a", builder.build());
        cacheManager.defineConfiguration("b", builder.build());
    }

    private void doTest(boolean awaitInitialTransfer) throws Exception {
        ConfigurationBuilder builder = this.getConfigurationBuilder(awaitInitialTransfer);
        this.addNode(this.getGlobalConfigurationBuilder("r1"), builder);
        this.addNode(this.getGlobalConfigurationBuilder("r1"), builder);
        this.waitForClusterToForm("a", "b");
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        String domain0 = this.manager(1).getCacheManagerConfiguration().jmx().domain();
        ObjectName ltmName0 = TestingUtil.getCacheManagerObjectName(domain0, "DefaultCacheManager", "LocalTopologyManager");
        String domain1 = this.manager(1).getCacheManagerConfiguration().jmx().domain();
        ObjectName ltmName1 = TestingUtil.getCacheManagerObjectName(domain1, "DefaultCacheManager", "LocalTopologyManager");
        ObjectName jmxCacheA = TestingUtil.getCacheObjectName(domain0, "a(" + this.cacheMode.name().toLowerCase() + ")");
        ObjectName jmxCacheB = TestingUtil.getCacheObjectName(domain0, "b(" + this.cacheMode.name().toLowerCase() + ")");
        DistributionManager dm0a = this.advancedCache(0, "a").getDistributionManager();
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Collection)dm0a.getCacheTopology().getCurrentCH().getMembers());
        AssertJUnit.assertNull((Object)dm0a.getCacheTopology().getPendingCH());
        DistributionManager dm0b = this.advancedCache(0, "b").getDistributionManager();
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Collection)dm0b.getCacheTopology().getCurrentCH().getMembers());
        AssertJUnit.assertNull((Object)dm0b.getCacheTopology().getPendingCH());
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(ltmName0));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, REBALANCING_ENABLED)));
        mBeanServer.setAttribute(ltmName0, new Attribute(REBALANCING_ENABLED, false));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, REBALANCING_ENABLED)));
        log.debugf("Starting 2 new nodes", new Object[0]);
        this.addNode(this.getGlobalConfigurationBuilder("r2"), builder);
        this.addNode(this.getGlobalConfigurationBuilder("r2"), builder);
        TestingUtil.blockUntilViewsReceived(3000, this.getCaches("a"));
        TestingUtil.blockUntilViewsReceived(3000, this.getCaches("b"));
        ClusterTopologyManager ctm2 = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(2), ClusterTopologyManager.class);
        AssertJUnit.assertFalse((boolean)ctm2.isRebalancingEnabled());
        ClusterTopologyManager ctm3 = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(3), ClusterTopologyManager.class);
        AssertJUnit.assertFalse((boolean)ctm3.isRebalancingEnabled());
        Thread.sleep(1000L);
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName1, REBALANCING_ENABLED)));
        AssertJUnit.assertNull((Object)dm0a.getCacheTopology().getPendingCH());
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Collection)dm0a.getCacheTopology().getCurrentCH().getMembers());
        mBeanServer.setAttribute(jmxCacheB, new Attribute(REBALANCING_ENABLED, false));
        log.debugf("Rebalancing with nodes %s %s %s %s", new Object[]{this.address(0), this.address(1), this.address(2), this.address(3)});
        mBeanServer.setAttribute(ltmName0, new Attribute(REBALANCING_ENABLED, true));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, REBALANCING_ENABLED)));
        this.checkRehashed(dm0a, this.getCaches("a"), Arrays.asList(this.address(0), this.address(1), this.address(2), this.address(3)));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(jmxCacheB, REBALANCING_ENABLED)));
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Collection)dm0b.getCacheTopology().getCurrentCH().getMembers());
        mBeanServer.setAttribute(jmxCacheB, new Attribute(REBALANCING_ENABLED, true));
        this.checkRehashed(dm0b, this.getCaches("b"), Arrays.asList(this.address(0), this.address(1), this.address(2), this.address(3)));
    }

    private void checkRehashed(DistributionManager dm, List<Cache<Object, Object>> caches, List<Address> addresses) {
        TestingUtil.waitForNoRebalance(caches);
        AssertJUnit.assertNull((Object)dm.getCacheTopology().getPendingCH());
        LocalizedCacheTopology topology = dm.getCacheTopology();
        ConsistentHash ch = topology.getCurrentCH();
        Assert.assertEquals(addresses, (Collection)ch.getMembers());
        int numOwners = Math.min(caches.get(0).getCacheConfiguration().clustering().hash().numOwners(), ch.getMembers().size());
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            Assert.assertEquals((int)numOwners, (int)ch.locateOwnersForSegment(i).size());
        }
    }
}

