/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.commons.time.TimeService;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.test.TestingUtil;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.CommitManagerTest")
public class CommitManagerTest {
    public void shouldStartAndStopTrackingCorrectly() {
        CommitManager manager = new CommitManager();
        Assert.assertFalse((boolean)manager.isTracking(Flag.PUT_FOR_STATE_TRANSFER));
        Assert.assertFalse((boolean)manager.isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER));
        manager.startTrack(Flag.PUT_FOR_STATE_TRANSFER);
        Assert.assertTrue((boolean)manager.isTracking(Flag.PUT_FOR_STATE_TRANSFER));
        manager.stopTrack(Flag.PUT_FOR_STATE_TRANSFER);
        Assert.assertFalse((boolean)manager.isTracking(Flag.PUT_FOR_STATE_TRANSFER));
        manager.startTrack(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
        Assert.assertTrue((boolean)manager.isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER));
        manager.stopTrack(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
        Assert.assertFalse((boolean)manager.isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER));
    }

    public void shouldCommitEntriesForSegment() throws Exception {
        int numberOfSegments = 10;
        InternalDataContainer container = (InternalDataContainer)Mockito.mock(InternalDataContainer.class);
        PersistenceManager persistenceManager = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        TimeService timeService = (TimeService)Mockito.mock(TimeService.class);
        CommitManager manager = new CommitManager();
        TestingUtil.inject(manager, container, persistenceManager, timeService);
        manager.startTrack(Flag.PUT_FOR_STATE_TRANSFER);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                String formatted = String.format("value-%d-%d", i, j);
                ReadCommittedEntry entry = new ReadCommittedEntry((Object)formatted, (Object)formatted, null);
                manager.commit((CacheEntry)entry, Flag.PUT_FOR_STATE_TRANSFER, i, false, null).toCompletableFuture().get(1L, TimeUnit.SECONDS);
            }
        }
        Assert.assertEquals((int)manager.tracker.size(), (int)0);
        Assert.assertTrue((boolean)manager.isEmpty());
        manager.stopTrackFor(Flag.PUT_FOR_STATE_TRANSFER, 0);
        manager.stopTrackFor(Flag.PUT_FOR_STATE_TRANSFER, 1);
        manager.stopTrackFor(Flag.PUT_FOR_STATE_TRANSFER, 2);
        Assert.assertTrue((boolean)manager.isTracking(Flag.PUT_FOR_STATE_TRANSFER));
        Assert.assertTrue((boolean)manager.isEmpty());
    }

    public void onlyClearSegmentIfNoXSiteST() throws Exception {
        int i2;
        int numberOfSegments = 10;
        IntPredicate isXSiteSegment = segment -> segment % 2 != 0;
        InternalDataContainer container = (InternalDataContainer)Mockito.mock(InternalDataContainer.class);
        PersistenceManager persistenceManager = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        TimeService timeService = (TimeService)Mockito.mock(TimeService.class);
        CommitManager manager = new CommitManager();
        TestingUtil.inject(manager, container, persistenceManager, timeService);
        manager.startTrack(Flag.PUT_FOR_STATE_TRANSFER);
        manager.startTrack(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
        for (i2 = 0; i2 < 10; ++i2) {
            for (int j = 0; j < 10; ++j) {
                String formatted = String.format("value-%d-%d", i2, j);
                ReadCommittedEntry entry = new ReadCommittedEntry((Object)formatted, (Object)formatted, null);
                CompletionStage future = isXSiteSegment.test(i2) ? manager.commit((CacheEntry)entry, Flag.PUT_FOR_X_SITE_STATE_TRANSFER, i2, false, null) : manager.commit((CacheEntry)entry, Flag.PUT_FOR_STATE_TRANSFER, i2, false, null);
                future.toCompletableFuture().get(1L, TimeUnit.SECONDS);
            }
        }
        Assert.assertEquals((int)manager.tracker.size(), (int)10);
        for (i2 = 0; i2 < 10; ++i2) {
            manager.stopTrackFor(Flag.PUT_FOR_STATE_TRANSFER, i2);
        }
        Assert.assertEquals((int)manager.tracker.size(), (int)5);
        Set expectedSegments = IntStream.range(0, 10).filter(i -> !isXSiteSegment.test(i)).boxed().collect(Collectors.toSet());
        Assert.assertEquals(manager.tracker.keySet(), expectedSegments);
    }
}

