/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.impl.EmptyRaftManager;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.raft.RaftManager;
import org.infinispan.topology.HeartBeatCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.testng.AssertJUnit;

@Scope(value=Scopes.GLOBAL)
public class MockTransport
implements Transport {
    private static final Log log = LogFactory.getLog(MockTransport.class);
    private final Address localAddress;
    private final BlockingQueue<BlockedRequest> blockedRequests = new LinkedBlockingDeque<BlockedRequest>();
    private int viewId;
    private List<Address> members;
    private CompletableFuture<Void> nextViewFuture;

    public MockTransport(Address localAddress) {
        this.localAddress = localAddress;
    }

    public void init(int viewId, List<Address> members) {
        this.viewId = viewId;
        this.members = members;
        this.nextViewFuture = new CompletableFuture();
    }

    public void updateView(int viewId, List<Address> members) {
        log.debugf("Installing view %d %s", viewId, members);
        this.viewId = viewId;
        this.members = members;
        CompletableFuture<Void> nextViewFuture = this.nextViewFuture;
        this.nextViewFuture = new CompletableFuture();
        nextViewFuture.complete(null);
    }

    public <T extends ReplicableCommand> BlockedRequest expectCommand(Class<T> expectedCommandClass) throws InterruptedException {
        return this.expectCommand(expectedCommandClass, c -> {});
    }

    public <T extends ReplicableCommand> BlockedRequest expectCommand(Class<T> expectedCommandClass, Consumer<T> checker) throws InterruptedException {
        BlockedRequest request = this.blockedRequests.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((String)"Timed out waiting for invocation", (Object)request);
        ReplicableCommand command = (ReplicableCommand)expectedCommandClass.cast(request.getCommand());
        checker.accept(command);
        return request;
    }

    public BlockedRequest expectHeartBeatCommand() throws InterruptedException {
        return this.expectCommand(HeartBeatCommand.class);
    }

    public BlockedRequest expectSingleRpcCommand(Class<? extends ReplicableCommand> wrappedCommand) throws InterruptedException {
        AssertJUnit.assertFalse((boolean)CacheRpcCommand.class.isAssignableFrom(wrappedCommand));
        return this.expectCommand(SingleRpcCommand.class, c -> AssertJUnit.assertTrue((boolean)wrappedCommand.isInstance(c.getCommand())));
    }

    public void verifyNoErrors() {
        AssertJUnit.assertTrue((String)("Unexpected remote invocations: " + this.blockedRequests.stream().map(i -> i.getCommand().toString()).collect(Collectors.joining(", "))), (boolean)this.blockedRequests.isEmpty());
    }

    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) {
        Collection<Address> targets = recipients != null ? recipients : this.members;
        MapResponseCollector collector = mode.isSynchronous() ? MapResponseCollector.ignoreLeavers((boolean)this.shouldIgnoreLeavers(mode), (int)targets.size()) : null;
        return this.blockRequest(recipients, rpcCommand, (ResponseCollector)collector);
    }

    public void sendTo(Address destination, ReplicableCommand rpcCommand, DeliverOrder deliverOrder) {
        this.blockRequest(Collections.singleton(destination), rpcCommand, null);
    }

    public void sendToMany(Collection<Address> destinations, ReplicableCommand rpcCommand, DeliverOrder deliverOrder) {
        this.blockRequest(destinations, rpcCommand, null);
    }

    public void sendToAll(ReplicableCommand rpcCommand, DeliverOrder deliverOrder) {
        this.blockRequest(this.members, rpcCommand, null);
    }

    @Deprecated(forRemoval=true)
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean totalOrder, boolean anycast) {
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=true)
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) {
        throw new UnsupportedOperationException();
    }

    public <O> XSiteResponse<O> backupRemotely(XSiteBackup backup, XSiteRequest<O> rpcCommand) {
        throw new UnsupportedOperationException();
    }

    public boolean isCoordinator() {
        return this.localAddress.equals((Object)this.members.get(0));
    }

    public Address getCoordinator() {
        return this.members.get(0);
    }

    public Address getAddress() {
        return this.localAddress;
    }

    public List<Address> getPhysicalAddresses() {
        throw new UnsupportedOperationException();
    }

    public List<Address> getMembers() {
        return this.members;
    }

    public List<Address> getMembersPhysicalAddresses() {
        throw new UnsupportedOperationException();
    }

    public boolean isMulticastCapable() {
        return true;
    }

    public void checkCrossSiteAvailable() throws CacheConfigurationException {
    }

    public String localSiteName() {
        return null;
    }

    @Start
    public void start() {
    }

    @Stop
    public void stop() {
    }

    public int getViewId() {
        return this.viewId;
    }

    public CompletableFuture<Void> withView(int expectedViewId) {
        if (this.viewId <= expectedViewId) {
            return CompletableFutures.completedNull();
        }
        return this.nextViewFuture.thenCompose(v -> this.withView(expectedViewId));
    }

    public Log getLog() {
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=true)
    public void checkTotalOrderSupported() {
    }

    public Set<String> getSitesView() {
        return null;
    }

    public boolean isSiteCoordinator() {
        return false;
    }

    public Collection<Address> getRelayNodesAddress() {
        return Collections.emptyList();
    }

    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.blockRequest(Collections.singleton(target), command, collector);
    }

    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.blockRequest(targets, command, collector);
    }

    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.blockRequest(this.members, command, collector);
    }

    public <T> CompletableFuture<T> invokeCommandOnAll(Collection<Address> requiredTargets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.blockRequest(requiredTargets, command, collector);
    }

    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.blockRequest(targets, command, collector);
    }

    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> responseCollector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public RaftManager raftManager() {
        return EmptyRaftManager.INSTANCE;
    }

    private <T> CompletableFuture<T> blockRequest(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector) {
        log.debugf("Intercepted command %s to %s", (Object)command, targets);
        BlockedRequest request = new BlockedRequest(command, collector);
        this.blockedRequests.add(request);
        return request.getResultFuture();
    }

    private boolean shouldIgnoreLeavers(ResponseMode mode) {
        return mode != ResponseMode.SYNCHRONOUS;
    }

    public static class BlockedRequest {
        private final ReplicableCommand command;
        private final ResponseCollector<?> collector;
        private final CompletableFuture<Object> resultFuture = new CompletableFuture();

        private BlockedRequest(ReplicableCommand command, ResponseCollector<?> collector) {
            this.command = command;
            this.collector = collector;
        }

        public BlockedRequest addResponse(Address sender, Response response) {
            AssertJUnit.assertFalse((boolean)this.isDone());
            log.debugf("Replying to remote invocation %s with %s from %s", (Object)this.getCommand(), (Object)response, (Object)sender);
            Object result = this.collector.addResponse(sender, response);
            if (result != null) {
                this.resultFuture.complete(result);
            }
            return this;
        }

        public BlockedRequest addLeaver(Address a) {
            return this.addResponse(a, (Response)CacheNotFoundResponse.INSTANCE);
        }

        public BlockedRequest addException(Address a, Exception e) {
            return this.addResponse(a, (Response)new ExceptionResponse(e));
        }

        public void throwException(Exception e) {
            this.resultFuture.completeExceptionally(e);
        }

        public void finish() {
            if (this.collector == null) {
                return;
            }
            try {
                Object result = this.collector.finish();
                this.resultFuture.complete(result);
            }
            catch (Throwable t) {
                this.resultFuture.completeExceptionally(t);
            }
        }

        public void singleResponse(Address sender, Response response) {
            this.addResponse(sender, response);
            if (!this.isDone()) {
                this.finish();
            }
        }

        public ReplicableCommand getCommand() {
            return this.command;
        }

        boolean isDone() {
            return this.resultFuture.isDone();
        }

        <U> CompletableFuture<U> getResultFuture() {
            return this.resultFuture;
        }
    }
}

