/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.profiling;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="profiling.AbstractProfileTest")
public abstract class AbstractProfileTest
extends SingleCacheManagerTest {
    protected static final String LOCAL_CACHE_NAME = "local";
    protected static final String REPL_SYNC_CACHE_NAME = "repl_sync";
    protected static final String REPL_ASYNC_CACHE_NAME = "repl_async";
    protected static final String DIST_SYNC_L1_CACHE_NAME = "dist_sync_l1";
    protected static final String DIST_ASYNC_L1_CACHE_NAME = "dist_async_l1";
    protected static final String DIST_SYNC_CACHE_NAME = "dist_sync";
    protected static final String DIST_ASYNC_CACHE_NAME = "dist_async";
    boolean startedInCmdLine = false;
    String clusterNameOverride = null;

    protected void initTest() throws Exception {
        System.out.println("Setting up test params!");
        if (this.startedInCmdLine) {
            this.cacheManager = this.createCacheManager();
        }
    }

    private ConfigurationBuilder getBaseCfg() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.locking().concurrencyLevel(5000).transaction().transactionManagerLookup((TransactionManagerLookup)new JBossStandaloneJTAManagerLookup());
        return cfg;
    }

    private ConfigurationBuilder getClusteredCfg(CacheMode mode, boolean l1) {
        ConfigurationBuilder cfg = this.getBaseCfg();
        cfg.locking().lockAcquisitionTimeout(60000L).clustering().cacheMode(mode).remoteTimeout(60000L).stateTransfer().fetchInMemoryState(false);
        if (mode.isDistributed()) {
            cfg.clustering().l1().enabled(l1).lifespan(120000L);
        }
        return cfg;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.transport().transportThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new WithinThreadExecutorFactory());
        this.cacheManager = TestCacheManagerFactory.createClusteredCacheManager(builder, new ConfigurationBuilder());
        this.cacheManager.defineConfiguration(LOCAL_CACHE_NAME, this.getBaseCfg().build());
        this.cacheManager.defineConfiguration(REPL_SYNC_CACHE_NAME, this.getClusteredCfg(CacheMode.REPL_SYNC, false).build());
        this.cacheManager.defineConfiguration(REPL_ASYNC_CACHE_NAME, this.getClusteredCfg(CacheMode.REPL_ASYNC, false).build());
        this.cacheManager.defineConfiguration(DIST_SYNC_CACHE_NAME, this.getClusteredCfg(CacheMode.DIST_SYNC, false).build());
        this.cacheManager.defineConfiguration(DIST_ASYNC_CACHE_NAME, this.getClusteredCfg(CacheMode.DIST_ASYNC, false).build());
        this.cacheManager.defineConfiguration(DIST_SYNC_L1_CACHE_NAME, this.getClusteredCfg(CacheMode.DIST_SYNC, true).build());
        this.cacheManager.defineConfiguration(DIST_ASYNC_L1_CACHE_NAME, this.getClusteredCfg(CacheMode.DIST_ASYNC, true).build());
        return this.cacheManager;
    }

    public static class WithinThreadExecutorFactory
    implements ThreadPoolExecutorFactory {
        public ExecutorService createExecutor(ThreadFactory factory) {
            return new WithinThreadExecutor();
        }

        public void validate() {
        }
    }
}

