/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.util.LongSummaryStatistics;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.marshall.exts.AbstractExternalizerTest;
import org.infinispan.marshall.exts.LongSummaryStatisticsExternalizer;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="marshall.LongSummaryStatisticsExternalizerTest")
public class LongSummaryStatisticsExternalizerTest
extends AbstractExternalizerTest<LongSummaryStatistics> {
    public void test() throws Exception {
        LongSummaryStatistics stats = new LongSummaryStatistics();
        stats.accept(1);
        stats.accept(-9223372036854775807L);
        LongSummaryStatistics deserialized = this.deserialize(stats);
        this.assertStatsAreEqual(stats, deserialized);
    }

    @Override
    AbstractExternalizer<LongSummaryStatistics> createExternalizer() {
        return new LongSummaryStatisticsExternalizer();
    }

    private void assertStatsAreEqual(LongSummaryStatistics original, LongSummaryStatistics deserialized) {
        Assert.assertEquals((long)original.getCount(), (long)deserialized.getCount());
        Assert.assertEquals((long)original.getMin(), (long)deserialized.getMin());
        Assert.assertEquals((long)original.getMax(), (long)deserialized.getMax());
        Assert.assertEquals((long)original.getSum(), (long)deserialized.getSum());
        Assert.assertEquals((Object)original.getAverage(), (Object)deserialized.getAverage());
    }
}

