/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheManagerAdminPermanentTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@Test(testName="manager.CacheManagerAdminSharedPermanentTest", groups={"functional"})
@CleanupAfterMethod
public class CacheManagerAdminSharedPermanentTest
extends CacheManagerAdminPermanentTest {
    @Override
    protected boolean isShared() {
        return true;
    }

    public void testSharedClusterCache() {
        this.waitForClusterToForm();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        Configuration configuration = builder.build();
        this.manager(0).administration().createCache("a", configuration);
        this.waitForClusterToForm("a");
        this.checkConsistencyAcrossCluster("a", configuration);
        TestingUtil.killCacheManagers(this.cacheManagers);
        this.cacheManagers.clear();
        this.createStatefulCacheManager("A", true);
        this.createStatefulCacheManager("B", true);
        this.checkConsistencyAcrossCluster("a", configuration);
    }
}

