/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import jakarta.transaction.Transaction;
import java.util.HashMap;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.MainOwnerChangesPessimisticLockTest")
@CleanupAfterMethod
public class MainOwnerChangesPessimisticLockTest
extends MultipleCacheManagersTest {
    public static final int NUM_KEYS = 10;
    private ConfigurationBuilder dccc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dccc = MainOwnerChangesPessimisticLockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.dccc.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis()).clustering().hash().numOwners(1).numSegments(3).l1().disable().stateTransfer().fetchInMemoryState(true);
        this.createCluster(TestDataSCI.INSTANCE, this.dccc, 2);
        this.waitForClusterToForm();
    }

    public void testLocalLockMigrationTxCommit() throws Exception {
        this.testLockMigration(0, true);
    }

    public void testLocalLockMigrationTxRollback() throws Exception {
        this.testLockMigration(0, false);
    }

    public void testRemoteLockMigrationTxCommit() throws Exception {
        this.testLockMigration(1, true);
    }

    public void testRemoteLockMigrationTxRollback() throws Exception {
        this.testLockMigration(1, false);
    }

    private void testLockMigration(int nodeThatPuts, boolean commit) throws Exception {
        HashMap<Object, Transaction> key2Tx = new HashMap<Object, Transaction>();
        for (int i = 0; i < 10; ++i) {
            Object key = this.getKeyForCache(0);
            if (key2Tx.containsKey(key)) continue;
            this.cache(nodeThatPuts).put(key, key);
            this.tm(nodeThatPuts).begin();
            Transaction tx = this.tm(nodeThatPuts).getTransaction();
            this.advancedCache(nodeThatPuts).lock(new Object[]{key});
            this.tm(nodeThatPuts).suspend();
            key2Tx.put(key, tx);
            this.assertLocked(0, key);
        }
        log.trace((Object)"Lock transfer happens here");
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, this.dccc);
        this.waitForClusterToForm();
        Object migratedKey = null;
        Transaction migratedTransaction = null;
        LocalizedCacheTopology cacheTopology = this.advancedCache(2).getDistributionManager().getCacheTopology();
        for (Object key : key2Tx.keySet()) {
            if (!cacheTopology.getDistribution(key).isPrimary()) continue;
            migratedKey = key;
            migratedTransaction = (Transaction)key2Tx.get(key);
            log.trace((Object)("Migrated key = " + String.valueOf(migratedKey)));
            log.trace((Object)("Migrated transaction = " + String.valueOf(((EmbeddedTransaction)migratedTransaction).getEnlistedResources())));
            break;
        }
        log.trace((Object)"Committing all transactions except the migrated one.");
        for (Object key : key2Tx.keySet()) {
            if (key.equals(migratedKey)) continue;
            Transaction tx = (Transaction)key2Tx.get(key);
            this.tm(nodeThatPuts).resume(tx);
            this.tm(nodeThatPuts).commit();
        }
        if (migratedKey == null) {
            log.trace((Object)"No key migrated to new owner - test cannot be performed!");
        } else {
            this.tm(nodeThatPuts).resume(migratedTransaction);
            if (commit) {
                this.tm(nodeThatPuts).commit();
            } else {
                this.tm(nodeThatPuts).rollback();
            }
            this.assertEventuallyNotLocked(this.cache(0), migratedKey);
            this.assertEventuallyNotLocked(this.cache(1), migratedKey);
            this.assertEventuallyNotLocked(this.cache(2), migratedKey);
            this.tm(nodeThatPuts).begin();
            this.cache(nodeThatPuts).put(migratedKey, (Object)"someValue");
            this.tm(nodeThatPuts).commit();
        }
        log.trace((Object)"Checking the values from caches...");
        for (Object key : key2Tx.keySet()) {
            log.tracef("Checking key: %s", key);
            Object expectedValue = key;
            if (key.equals(migratedKey)) {
                expectedValue = "someValue";
            }
            InternalCacheEntry d0 = this.advancedCache(0).getDataContainer().get(key);
            InternalCacheEntry d1 = this.advancedCache(1).getDataContainer().get(key);
            InternalCacheEntry d2 = this.advancedCache(2).getDataContainer().get(key);
            int c = 0;
            if (d0 != null && !d0.isExpired(TIME_SERVICE.wallClockTime())) {
                AssertJUnit.assertEquals(expectedValue, (Object)d0.getValue());
                ++c;
            }
            if (d1 != null && !d1.isExpired(TIME_SERVICE.wallClockTime())) {
                AssertJUnit.assertEquals(expectedValue, (Object)d1.getValue());
                ++c;
            }
            if (d2 != null && !d2.isExpired(TIME_SERVICE.wallClockTime())) {
                AssertJUnit.assertEquals(expectedValue, (Object)d2.getValue());
                ++c;
            }
            AssertJUnit.assertEquals((int)1, (int)c);
            AssertJUnit.assertEquals(expectedValue, (Object)this.cache(0).get(key));
            AssertJUnit.assertEquals(expectedValue, (Object)this.cache(1).get(key));
            AssertJUnit.assertEquals(expectedValue, (Object)this.cache(2).get(key));
        }
    }
}

