/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.lock.FailInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="lock.StaleEagerLocksOnPrepareFailureTest", groups={"functional"})
@CleanupAfterMethod
public class StaleEagerLocksOnPrepareFailureTest
extends MultipleCacheManagersTest {
    Cache<MagicKey, String> c1;
    Cache<MagicKey, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = StaleEagerLocksOnPrepareFailureTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        cfg.transaction().lockingMode(LockingMode.PESSIMISTIC).useSynchronization(false).recovery().disable().locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.createCluster(TestDataSCI.INSTANCE, cfg, 2);
        this.waitForClusterToForm();
        this.c1 = this.cache(0);
        this.c2 = this.cache(1);
    }

    public void testNoModsCommit() throws Exception {
        this.doTest(false);
    }

    public void testModsCommit() throws Exception {
        this.doTest(true);
    }

    private void doTest(boolean mods) throws Exception {
        FailInterceptor interceptor = new FailInterceptor();
        interceptor.failFor(PrepareCommand.class);
        AsyncInterceptorChain ic = TestingUtil.extractInterceptorChain(this.c2);
        ic.addInterceptorBefore((AsyncInterceptor)interceptor, TxDistributionInterceptor.class);
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.tm(this.c1).begin();
        if (mods) {
            this.c1.put((Object)k1, (Object)"v1");
            this.c1.put((Object)k2, (Object)"v2");
            this.assertKeyLockedCorrectly(k1);
            this.assertKeyLockedCorrectly(k2);
        } else {
            this.c1.getAdvancedCache().lock((Object[])new MagicKey[]{k1});
            this.c1.getAdvancedCache().lock((Object[])new MagicKey[]{k2});
            Assert.assertNull((Object)this.c1.get((Object)k1));
            Assert.assertNull((Object)this.c1.get((Object)k2));
            this.assertKeyLockedCorrectly(k1);
            this.assertKeyLockedCorrectly(k2);
        }
        try {
            this.tm(this.c1).commit();
            assert (false) : "Commit should have failed";
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertEventuallyNotLocked(this.c1, k1);
        this.assertEventuallyNotLocked(this.c2, k1);
        this.assertEventuallyNotLocked(this.c1, k2);
        this.assertEventuallyNotLocked(this.c2, k2);
    }
}

