/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheManagerMBeanTest")
public class CacheManagerMBeanTest
extends SingleCacheManagerTest {
    private static final String JMX_DOMAIN = CacheManagerMBeanTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private final MBeanServer server = this.mBeanServerLookup.getMBeanServer();
    private ObjectName name;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        globalConfiguration.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder configuration = new ConfigurationBuilder();
        this.cacheManager = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration);
        this.name = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN);
        this.mBeanServerLookup.getMBeanServer().invoke(this.name, "startCache", new Object[0], new String[0]);
        return this.cacheManager;
    }

    public void testJmxOperations() throws Exception {
        AssertJUnit.assertEquals((Object)"1", (Object)this.server.getAttribute(this.name, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"1", (Object)this.server.getAttribute(this.name, "DefinedCacheCount"));
        AssertJUnit.assertEquals((Object)String.format("[%s(created)]", this.getDefaultCacheName()), (Object)this.server.getAttribute(this.name, "DefinedCacheNames"));
        AssertJUnit.assertEquals((Object)"1", (Object)this.server.getAttribute(this.name, "RunningCacheCount"));
        this.cacheManager.defineConfiguration("a", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("b", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("c", new ConfigurationBuilder().build());
        AssertJUnit.assertEquals((Object)"1", (Object)this.server.getAttribute(this.name, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"4", (Object)this.server.getAttribute(this.name, "DefinedCacheCount"));
        AssertJUnit.assertEquals((Object)"1", (Object)this.server.getAttribute(this.name, "RunningCacheCount"));
        String attribute = (String)this.server.getAttribute(this.name, "DefinedCacheConfigurationNames");
        Object[] names = attribute.substring(1, attribute.length() - 1).split(",");
        AssertJUnit.assertTrue((Arrays.binarySearch(names, "a") >= 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((Arrays.binarySearch(names, "b") >= 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((Arrays.binarySearch(names, "c") >= 0 ? 1 : 0) != 0);
        this.server.invoke(this.name, "startCache", new Object[]{"a"}, new String[]{String.class.getName()});
        this.server.invoke(this.name, "startCache", new Object[]{"b"}, new String[]{String.class.getName()});
        AssertJUnit.assertEquals((Object)"3", (Object)this.server.getAttribute(this.name, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"4", (Object)this.server.getAttribute(this.name, "DefinedCacheCount"));
        AssertJUnit.assertEquals((Object)"3", (Object)this.server.getAttribute(this.name, "RunningCacheCount"));
        attribute = (String)this.server.getAttribute(this.name, "DefinedCacheNames");
        AssertJUnit.assertTrue((boolean)attribute.contains("a("));
        AssertJUnit.assertTrue((boolean)attribute.contains("b("));
        AssertJUnit.assertTrue((boolean)attribute.contains("c("));
    }

    public void testJmxOperationMetadata() throws Exception {
        TestingUtil.checkMBeanOperationParameterNaming(this.mBeanServerLookup.getMBeanServer(), this.name);
    }

    public void testInvokeJmxOperationNotExposed() {
        Exceptions.expectException(MBeanException.class, ServiceNotFoundException.class, () -> this.mBeanServerLookup.getMBeanServer().invoke(this.name, "stop", new Object[0], new String[0]));
    }

    public void testSameDomain() {
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder c = new ConfigurationBuilder();
        Exceptions.expectException(EmbeddedCacheManagerStartupException.class, () -> TestCacheManagerFactory.createCacheManager(gc, c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJmxRegistrationAtStartupAndStop(Method m) throws Exception {
        String otherJmxDomain = JMX_DOMAIN + "_" + m.getName();
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.jmx().enabled(true).domain(otherJmxDomain).mBeanServerLookup(this.mBeanServerLookup);
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManager(gc, null);
        ObjectName otherName = TestingUtil.getCacheManagerObjectName(otherJmxDomain);
        try {
            AssertJUnit.assertEquals((Object)"0", (Object)this.mBeanServerLookup.getMBeanServer().getAttribute(otherName, "CreatedCacheCount"));
        }
        finally {
            otherContainer.stop();
        }
        Exceptions.expectException(InstanceNotFoundException.class, () -> this.mBeanServerLookup.getMBeanServer().getAttribute(otherName, "CreatedCacheCount"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomCacheManagerName(Method m) throws Exception {
        String otherJmxDomain = JMX_DOMAIN + "_" + m.getName();
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.jmx().enabled(true).domain(otherJmxDomain).mBeanServerLookup(this.mBeanServerLookup);
        gc.cacheManagerName("Hibernate2LC");
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManager(gc, null);
        try {
            ObjectName otherName = TestingUtil.getCacheManagerObjectName(otherJmxDomain, "Hibernate2LC");
            AssertJUnit.assertEquals((Object)"0", (Object)this.mBeanServerLookup.getMBeanServer().getAttribute(otherName, "CreatedCacheCount"));
        }
        finally {
            otherContainer.stop();
        }
    }

    public void testAddressInformation() throws Exception {
        AssertJUnit.assertEquals((Object)"local", (Object)this.server.getAttribute(this.name, "NodeAddress"));
        AssertJUnit.assertEquals((Object)"local", (Object)this.server.getAttribute(this.name, "ClusterMembers"));
        AssertJUnit.assertEquals((Object)"local", (Object)this.server.getAttribute(this.name, "PhysicalAddresses"));
        AssertJUnit.assertEquals((Object)1, (Object)this.server.getAttribute(this.name, "ClusterSize"));
    }

    @Test(dependsOnMethods={"testJmxOperations"})
    public void testCacheMBeanUnregisterOnRemove() {
        this.cacheManager.defineConfiguration("test", new ConfigurationBuilder().build());
        AssertJUnit.assertNotNull((Object)this.cacheManager.getCache("test"));
        ObjectName cacheMBean = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(cacheMBean));
        this.cacheManager.administration().removeCache("test");
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(cacheMBean));
    }

    public void testExecutorMBeans() throws Exception {
        ScheduledExecutorService timeoutExecutor = TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, ScheduledExecutorService.class, "org.infinispan.executors.timeout");
        timeoutExecutor.submit(() -> {});
        ObjectName objectName = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN, "DefaultCacheManager", "org.infinispan.executors.timeout");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(objectName));
        AssertJUnit.assertEquals((Object)1, (Object)this.server.getAttribute(objectName, "PoolSize"));
        AssertJUnit.assertEquals((Object)Integer.MAX_VALUE, (Object)this.server.getAttribute(objectName, "MaximumPoolSize"));
    }
}

