/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheConfigurationMBeanTest")
public class CacheConfigurationMBeanTest
extends SingleCacheManagerTest {
    private static final String JMX_DOMAIN = CacheConfigurationMBeanTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder dcc = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        dcc.transaction().autoCommit(false);
        dcc.memory().size(1000L);
        return TestCacheManagerFactory.createCacheManager(gcb, dcc);
    }

    public void testEvictionSize() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName defaultOn = TestingUtil.getCacheObjectName(JMX_DOMAIN, this.getDefaultCacheName() + "(local)", "Configuration");
        AssertJUnit.assertEquals((long)1000L, (long)((Long)mBeanServer.getAttribute(defaultOn, "evictionSize")));
        AssertJUnit.assertEquals((long)1000L, (long)this.cache().getCacheConfiguration().memory().size());
        DefaultDataContainer dataContainer = (DefaultDataContainer)this.cache().getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((long)1000L, (long)dataContainer.capacity());
        mBeanServer.setAttribute(defaultOn, new Attribute("evictionSize", 2000L));
        AssertJUnit.assertEquals((long)2000L, (long)this.cache().getCacheConfiguration().memory().size());
        AssertJUnit.assertEquals((long)2000L, (long)dataContainer.capacity());
    }
}

