/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.io.Serializable;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="interceptors.impl.CacheWriterTxModificationsTest")
public class CacheWriterTxModificationsTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC);
        config.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        return TestCacheManagerFactory.createCacheManager(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommit() throws Throwable {
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create((AdvancedCache)this.cache.getAdvancedCache());
        FunctionalMap.WriteOnlyMap woMap = WriteOnlyMapImpl.create((FunctionalMapImpl)functionalMap);
        FunctionalMap.ReadWriteMap rwMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        this.cache.putAll(TestingUtil.mapOf("remove", "initial", "replace", "initial", "computeIfPresent", "initial", "woRemove", "initial", "rwRemove", "initial"));
        this.tm().begin();
        try {
            this.cache.put((Object)"put", (Object)"value");
            this.cache.putIfAbsent((Object)"putIfAbsent", (Object)"value");
            this.cache.remove((Object)"remove");
            this.cache.replace((Object)"replace", (Object)"value");
            this.cache.compute((Object)"compute", (SerializableBiFunction & Serializable)(k, v) -> "value");
            this.cache.computeIfAbsent((Object)"computeIfAbsent", (SerializableFunction & Serializable)k -> "value");
            this.cache.computeIfPresent((Object)"computeIfPresent", (SerializableBiFunction & Serializable)(k, v) -> "value");
            this.cache.putAll(TestingUtil.mapOf("putAll", "value"));
            woMap.eval((Object)"woSet", (SerializableConsumer & Serializable)entry -> entry.set((Object)"value", new MetaParam.Writable[0]));
            woMap.eval((Object)"woRemove", (SerializableConsumer & Serializable)entry -> entry.set((Object)"value", new MetaParam.Writable[0]));
            woMap.eval((Object)"rwSet", (SerializableConsumer & Serializable)entry -> entry.set((Object)"value", new MetaParam.Writable[0]));
            woMap.eval((Object)"rwRemove", (SerializableConsumer & Serializable)entry -> entry.set((Object)"value", new MetaParam.Writable[0]));
        }
        finally {
            this.tm().commit();
        }
        DataContainer dataContainer = this.cache.getAdvancedCache().getDataContainer();
        dataContainer.forEach(entry -> {
            MarshallableEntry storeEntry = store.loadEntry(entry.getKey());
            AssertJUnit.assertNotNull((String)("Missing store entry: " + String.valueOf(entry.getKey())), storeEntry);
            AssertJUnit.assertEquals((Object)entry.getValue(), (Object)storeEntry.getValue());
        });
        store.keySet().forEach(k -> AssertJUnit.assertEquals((Object)store.loadEntry(k).getValue(), (Object)dataContainer.get(k).getValue()));
    }
}

