/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.partitionhandling.BaseStatefulPartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.MissingMembersException;
import org.infinispan.topology.PersistentUUID;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="globalstate.NodeRestartPartitionHandlingTest")
public class NodeRestartPartitionHandlingTest
extends BaseStatefulPartitionHandlingTest {
    public NodeRestartPartitionHandlingTest() {
        this.partitionHandling = PartitionHandling.ALLOW_READ_WRITES;
        this.numMembersInCluster = 2;
    }

    public void testRestartDuringNetworkPartition() throws Throwable {
        int i;
        Map<JGroupsAddress, PersistentUUID> addressMappings = this.createInitialCluster();
        ConsistentHash oldConsistentHash = this.advancedCache(0, "testCache").getDistributionManager().getWriteConsistentHash();
        for (i = 0; i < this.numMembersInCluster; ++i) {
            ((DefaultCacheManager)this.manager(i)).shutdownAllCaches();
        }
        TestingUtil.killCacheManagers(this.cacheManagers);
        for (i = 0; i < this.numMembersInCluster; ++i) {
            String persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            Object[] listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)1, (int)listFiles.length);
        }
        this.cacheManagers.clear();
        this.createStatefulCacheManagers(false);
        this.splitCluster({0}, {1});
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
        for (i = 0; i < this.numMembersInCluster; ++i) {
            this.cache(i, "testCache");
        }
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
        this.assertOperationsFail();
        this.partition(0).merge(this.partition(1), false);
        this.waitForClusterToForm("testCache");
        this.assertHealthyCluster(addressMappings, oldConsistentHash);
    }

    private void assertOperationsFail() {
        for (int i = 0; i < this.cacheManagers.size(); ++i) {
            for (int v = 0; v < 100; ++v) {
                Cache cache = this.cache(i, "testCache");
                String key = String.valueOf(v);
                Exceptions.expectException(MissingMembersException.class, (String)"ISPN000689: Recovering cache 'testCache' but there are missing members, known members \\[.*\\] of a total of 2$", () -> cache.get((Object)key));
            }
        }
    }
}

