/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="executors.ExecutorAllCompletionServiceTest")
public class ExecutorAllCompletionServiceTest
extends AbstractInfinispanTest {
    private ExecutorService lastExecutorService;

    @AfterClass(alwaysRun=true)
    public void stopExecutors() {
        if (this.lastExecutorService != null) {
            this.lastExecutorService.shutdownNow();
        }
    }

    public void testWaitForAll() {
        ExecutorAllCompletionService service = this.createService(1);
        long before = System.currentTimeMillis();
        service.submit((Runnable)new WaitRunnable(500L), null);
        service.submit((Runnable)new WaitRunnable(500L), null);
        service.waitUntilAllCompleted();
        long after = System.currentTimeMillis();
        AssertJUnit.assertTrue((after - before >= 1000L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)service.isAllCompleted());
        AssertJUnit.assertFalse((boolean)service.isExceptionThrown());
    }

    public void testExceptions() {
        ExecutorAllCompletionService service = this.createService(1);
        service.submit((Runnable)new WaitRunnable(1L), null);
        service.submit((Runnable)new ExceptionRunnable("second"), null);
        service.submit((Runnable)new WaitRunnable(1L), null);
        service.submit((Runnable)new ExceptionRunnable("third"), null);
        service.waitUntilAllCompleted();
        AssertJUnit.assertTrue((boolean)service.isAllCompleted());
        AssertJUnit.assertTrue((boolean)service.isExceptionThrown());
        AssertJUnit.assertEquals((String)"second", (String)this.findCause(service.getFirstException()).getMessage());
    }

    public void testParallelWait() throws InterruptedException {
        ExecutorAllCompletionService service = this.createService(2);
        for (int i = 0; i < 300; ++i) {
            service.submit((Runnable)new WaitRunnable(10L), null);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>(10);
        for (int i = 0; i < 10; ++i) {
            Thread t = new Thread(() -> {
                service.waitUntilAllCompleted();
                AssertJUnit.assertTrue((boolean)service.isAllCompleted());
                AssertJUnit.assertFalse((boolean)service.isExceptionThrown());
            });
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        AssertJUnit.assertTrue((boolean)service.isAllCompleted());
        AssertJUnit.assertFalse((boolean)service.isExceptionThrown());
    }

    public void testParallelException() throws InterruptedException {
        int i;
        ExecutorAllCompletionService service = this.createService(2);
        for (i = 0; i < 150; ++i) {
            service.submit((Runnable)new WaitRunnable(10L), null);
        }
        service.submit((Runnable)new ExceptionRunnable("foobar"), null);
        for (i = 0; i < 150; ++i) {
            service.submit((Runnable)new WaitRunnable(10L), null);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>(10);
        for (int i2 = 0; i2 < 10; ++i2) {
            Thread t = new Thread(() -> {
                service.waitUntilAllCompleted();
                AssertJUnit.assertTrue((boolean)service.isAllCompleted());
                AssertJUnit.assertTrue((boolean)service.isExceptionThrown());
            });
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        AssertJUnit.assertTrue((boolean)service.isAllCompleted());
        AssertJUnit.assertTrue((boolean)service.isExceptionThrown());
    }

    private Throwable findCause(ExecutionException e) {
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private ExecutorAllCompletionService createService(int maxThreads) {
        if (this.lastExecutorService != null) {
            this.lastExecutorService.shutdownNow();
        }
        this.lastExecutorService = Executors.newFixedThreadPool(maxThreads, this.getTestThreadFactory("Worker"));
        return new ExecutorAllCompletionService((Executor)this.lastExecutorService);
    }

    private static class WaitRunnable
    implements Runnable {
        private final long period;

        private WaitRunnable(long period) {
            this.period = period;
        }

        @Override
        public void run() {
            TestingUtil.sleepThread(this.period);
        }
    }

    private static class ExceptionRunnable
    implements Runnable {
        private final String message;

        public ExceptionRunnable(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            throw new RuntimeException(this.message);
        }
    }
}

