/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="eviction.ExpensiveEvictionTest")
public class ExpensiveEvictionTest
extends SingleCacheManagerTest {
    private final Integer MAX_CACHE_ELEMENTS = 10000000;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.memory().size((long)this.MAX_CACHE_ELEMENTS.intValue()).expiration().wakeUpInterval(3000L).build();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cfg);
        this.cache = cm.getCache();
        return cm;
    }

    public void testSimpleEvictionMaxEntries() throws Exception {
        log.tracef("Max entries: ", (Object)this.MAX_CACHE_ELEMENTS);
        for (int i = 0; i < this.MAX_CACHE_ELEMENTS; ++i) {
            Integer integer = i;
            this.cache.put((Object)integer, (Object)integer, 6L, TimeUnit.HOURS);
            if (i % 50000 != 0) continue;
            log.tracef("Elements in cache: %s", this.cache.size());
        }
        log.debug((Object)"Finished filling in cache. Now idle while evicting thread works....");
        Thread.sleep(TimeUnit.MILLISECONDS.convert(2L, TimeUnit.HOURS));
    }
}

