/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="commands.OffHeapMultiNodeTest")
public class OffHeapMultiNodeTest
extends MultipleCacheManagersTest {
    protected static final int NUMBER_OF_KEYS = 10;
    static final int KEY_SIZE = 20;
    static final int VALUE_SIZE = 1024;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = OffHeapMultiNodeTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        dcc.memory().storageType(StorageType.OFF_HEAP);
        dcc.clustering().stateTransfer().timeout(30L, TimeUnit.SECONDS);
        this.createCluster(dcc, 4);
        this.waitForClusterToForm();
    }

    public void testPutMapCommand() {
        int i;
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>();
        for (i = 0; i < 10; ++i) {
            map.put((CallSite)((Object)("key" + i)), (CallSite)((Object)("value" + i)));
        }
        this.cache(0).putAll(map);
        for (i = 0; i < 10; ++i) {
            AssertJUnit.assertEquals((Object)("value" + i), (Object)this.cache(0).get((Object)("key" + i)));
        }
    }

    public void testPutRemovePut() {
        Cache map = this.cache(0);
        byte[] key = this.randomBytes(20);
        byte[] value = this.randomBytes(1024);
        byte[] value2 = this.randomBytes(1024);
        AssertJUnit.assertNull((Object)map.put((byte[])key, (byte[])value));
        for (int i = 0; i < 10; ++i) {
            map.put((byte[])this.randomBytes(20), (byte[])value);
        }
        AssertJUnit.assertEquals((byte[])value, (byte[])((byte[])map.remove(key)));
        AssertJUnit.assertNull((Object)map.put((byte[])key, (byte[])value));
        AssertJUnit.assertEquals((byte[])value, (byte[])((byte[])map.remove(key)));
        AssertJUnit.assertNull((Object)map.put((byte[])key, (byte[])value2));
    }

    public void testOverwriteSameKey() {
        Cache map = this.cache(0);
        byte[] key = this.randomBytes(20);
        byte[] value = this.randomBytes(1024);
        byte[] value2 = this.randomBytes(1024);
        byte[] value3 = this.randomBytes(1024);
        AssertJUnit.assertNull((Object)map.put((byte[])key, (byte[])value));
        byte[] prev = map.put((byte[])key, (byte[])value2);
        AssertJUnit.assertTrue((boolean)Arrays.equals(prev, value));
        AssertJUnit.assertTrue((boolean)Arrays.equals(value2, map.put((byte[])key, (byte[])value3)));
        AssertJUnit.assertTrue((boolean)Arrays.equals(value3, (byte[])map.get(key)));
    }

    public void testClear() {
        int i;
        Cache map = this.cache(0);
        int size = 10;
        for (i = 0; i < 10; ++i) {
            map.put((CallSite)((Object)("key-" + i)), (CallSite)((Object)("value-" + i)));
        }
        AssertJUnit.assertEquals((int)size, (int)map.size());
        for (i = 0; i < 10; ++i) {
            AssertJUnit.assertEquals((String)("value-" + i), (String)((String)map.get("key-" + i)));
        }
        map.clear();
        AssertJUnit.assertEquals((int)0, (int)map.size());
        for (i = 0; i < 10; ++i) {
            map.put((CallSite)((Object)("key-" + i)), (CallSite)((Object)("value-" + i)));
        }
        AssertJUnit.assertEquals((int)size, (int)map.size());
    }

    public void testIterate() {
        int cacheSize = 10;
        HashMap<byte[], byte[]> original = new HashMap<byte[], byte[]>();
        for (int i = 0; i < cacheSize; ++i) {
            byte[] key = this.randomBytes(20);
            original.put(key, this.randomBytes(1024));
        }
        Cache map = this.cache(0);
        map.putAll(original);
        Iterator iterator = map.entrySet().iterator();
        AtomicInteger count = new AtomicInteger();
        iterator.forEachRemaining(e -> {
            count.incrementAndGet();
            AssertJUnit.assertEquals((byte[])((byte[])e.getValue()), (byte[])((byte[])map.get(e.getKey())));
        });
        AssertJUnit.assertEquals((int)cacheSize, (int)count.get());
    }

    public void testRemoveSegments() {
        int segmentWrittenTo;
        Object primaryOwnerCache;
        Cache cache = this.cache(0);
        if (cache.getCacheConfiguration().clustering().cacheMode() == CacheMode.LOCAL) {
            return;
        }
        String key = "some-key";
        String value = "some-value";
        DataConversion keyDataConversion = cache.getAdvancedCache().getKeyDataConversion();
        DataConversion valueDataConversion = cache.getAdvancedCache().getValueDataConversion();
        Object storedKey = keyDataConversion.toStorage((Object)key);
        Object storedValue = valueDataConversion.toStorage((Object)value);
        List caches = this.caches();
        if (caches.size() == 1) {
            primaryOwnerCache = cache;
            segmentWrittenTo = 0;
        } else {
            primaryOwnerCache = DistributionTestHelper.getFirstOwner(storedKey, this.caches());
            KeyPartitioner keyPartitioner = TestingUtil.extractComponent(primaryOwnerCache, KeyPartitioner.class);
            segmentWrittenTo = keyPartitioner.getSegment(storedKey);
        }
        InternalDataContainer container = TestingUtil.extractComponent(primaryOwnerCache, InternalDataContainer.class);
        AssertJUnit.assertEquals((int)0, (int)container.size());
        container.put(storedKey, storedValue, new EmbeddedMetadata.Builder().build());
        AssertJUnit.assertEquals((int)1, (int)container.size());
        container.removeSegments(IntSets.immutableSet((int)segmentWrittenTo));
        AssertJUnit.assertEquals((int)0, (int)container.size());
    }

    static DataContainer<WrappedByteArray, WrappedByteArray> castDC(Object obj) {
        return (DataContainer)obj;
    }

    byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }
}

