/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.jgroups.protocols.relay.RELAY2;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteInlineConfigFileParsingTest")
public class XSiteInlineConfigFileParsingTest
extends SingleCacheManagerTest {
    public static final String FILE_NAME = "configs/xsite/xsite-inline-test.xml";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilderHolder holder = TestCacheManagerFactory.parseFile(FILE_NAME, false);
        TransportFlags flags = new TransportFlags().withPreserveConfig(true);
        return TestCacheManagerFactory.createClusteredCacheManager(true, holder, flags);
    }

    public void testInlineConfiguration() {
        GlobalConfiguration cmc = this.cacheManager.getCacheManagerConfiguration();
        JGroupsTransport transport = (JGroupsTransport)TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, Transport.class);
        RELAY2 relay2 = (RELAY2)transport.getChannel().getProtocolStack().findProtocol(RELAY2.class);
        AssertJUnit.assertEquals((int)3, (int)relay2.getSites().size());
        AssertJUnit.assertTrue((boolean)relay2.getSites().contains("LON"));
        AssertJUnit.assertTrue((boolean)relay2.getSites().contains("SFO"));
        AssertJUnit.assertTrue((boolean)relay2.getSites().contains("NYC"));
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)2);
        BackupConfigurationBuilder nyc = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.IGNORE).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc.create()));
        BackupConfigurationBuilder sfo = new BackupConfigurationBuilder(null).site("SFO").strategy(BackupConfiguration.BackupStrategy.ASYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(15000L).useTwoPhaseCommit(false);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(sfo.create()));
    }
}

