/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.function.SerializableConsumer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.MetadataAPITest")
public class MetadataAPITest
extends SingleCacheManagerTest {
    AdvancedCache<Integer, String> advCache;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(true);
        this.advCache = cm.getCache().getAdvancedCache();
        return cm;
    }

    public void testPutWithVersion() {
        Integer key = 1;
        NumericVersion version = new NumericVersion(1L);
        this.advCache.put((Object)key, (Object)"v1", this.withVersion((EntryVersion)version));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.EQUAL, (Object)version.compareTo(cacheEntry.getMetadata().version()));
    }

    public void testConditionalReplaceWithVersion() {
        Integer key = 2;
        NumericVersion version = new NumericVersion(1L);
        this.advCache.put((Object)key, (Object)"v1", this.withVersion((EntryVersion)version));
        NumericVersion newVersion = new NumericVersion(2L);
        this.advCache.replace((Object)key, (Object)"v1", (Object)"v2", this.withVersion((EntryVersion)newVersion));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.EQUAL, (Object)newVersion.compareTo(cacheEntry.getMetadata().version()));
    }

    public void testPutIfAbsentWithVersion() {
        Integer key = 3;
        NumericVersion version = new NumericVersion(1L);
        AssertJUnit.assertEquals(null, (String)((String)this.advCache.putIfAbsent((Object)key, (Object)"v1", this.withVersion((EntryVersion)version))));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.EQUAL, (Object)version.compareTo(cacheEntry.getMetadata().version()));
    }

    public void testPutAsyncWithVersion() throws Exception {
        Integer key = 4;
        NumericVersion version = new NumericVersion(1L);
        CompletableFuture f = this.advCache.putAsync((Object)key, (Object)"v1", this.withVersion((EntryVersion)version));
        AssertJUnit.assertNotNull((Object)f);
        AssertJUnit.assertFalse((boolean)f.isCancelled());
        AssertJUnit.assertNull(f.get());
        AssertJUnit.assertTrue((boolean)f.isDone());
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)"v1", (Object)entry.getValue());
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.EQUAL, (Object)version.compareTo(entry.getMetadata().version()));
    }

    public void testPutWithLifespan() {
        Integer key = 1;
        int lifespan = 1000000;
        this.advCache.put((Object)key, (Object)"v1", this.withLifespan(lifespan));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((long)lifespan, (long)cacheEntry.getMetadata().lifespan());
    }

    public void testConditionalReplaceWithLifespan() {
        Integer key = 2;
        long lifespan = 1000000L;
        this.advCache.put((Object)key, (Object)"v1", this.withLifespan(lifespan));
        long newLifespan = 2000000L;
        this.advCache.replace((Object)key, (Object)"v1", (Object)"v2", this.withLifespan(newLifespan));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((long)newLifespan, (long)cacheEntry.getMetadata().lifespan());
    }

    public void testPutIfAbsentWithLifespan() {
        Integer key = 3;
        long lifespan = 1000000L;
        AssertJUnit.assertEquals(null, (String)((String)this.advCache.putIfAbsent((Object)key, (Object)"v1", this.withLifespan(lifespan))));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((long)lifespan, (long)cacheEntry.getMetadata().lifespan());
    }

    public void testPutAsyncWithLifespan() throws Exception {
        Integer key = 4;
        long lifespan = 1000000L;
        CompletableFuture f = this.advCache.putAsync((Object)key, (Object)"v1", this.withLifespan(lifespan));
        AssertJUnit.assertNotNull((Object)f);
        AssertJUnit.assertFalse((boolean)f.isCancelled());
        AssertJUnit.assertNull(f.get());
        AssertJUnit.assertTrue((boolean)f.isDone());
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)"v1", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)lifespan, (long)entry.getMetadata().lifespan());
    }

    public void testPutFunctionalWithLifespan() throws Exception {
        Integer key = 4;
        long lifespan = 1000000L;
        CompletableFuture f = WriteOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(this.advCache)).eval((Object)key, (SerializableConsumer & Serializable)view -> view.set((Object)"v1", new MetaParam.Writable[]{new MetaParam.MetaLifespan(lifespan)}));
        AssertJUnit.assertNotNull((Object)f);
        AssertJUnit.assertFalse((boolean)f.isCancelled());
        AssertJUnit.assertNull(f.get());
        AssertJUnit.assertTrue((boolean)f.isDone());
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)"v1", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)lifespan, (long)entry.getMetadata().lifespan());
    }

    public void testReplaceFunctionalWithLifespan() throws Exception {
        Integer key = 4;
        long lifespan = 1000000L;
        CompletableFuture f = WriteOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(this.advCache)).eval((Object)key, (SerializableConsumer & Serializable)view -> view.set((Object)"v1", new MetaParam.Writable[]{new MetaParam.MetaLifespan(lifespan)}));
        AssertJUnit.assertNotNull((Object)f);
        AssertJUnit.assertFalse((boolean)f.isCancelled());
        AssertJUnit.assertNull(f.get());
        AssertJUnit.assertTrue((boolean)f.isDone());
        long newLifespan = 2000000L;
        f = WriteOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(this.advCache)).eval((Object)key, (SerializableConsumer & Serializable)view -> view.set((Object)"v2", new MetaParam.Writable[]{new MetaParam.MetaLifespan(newLifespan)}));
        AssertJUnit.assertNotNull((Object)f);
        AssertJUnit.assertFalse((boolean)f.isCancelled());
        AssertJUnit.assertNull(f.get());
        AssertJUnit.assertTrue((boolean)f.isDone());
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)"v2", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)newLifespan, (long)entry.getMetadata().lifespan());
    }

    public void testReplaceEmbeddedFunctionalWithLifespan() throws Exception {
        Integer key = 4;
        long lifespan = 1000000L;
        this.advCache.put((Object)key, (Object)"v1", this.withLifespan(lifespan));
        long newLifespan = 2000000L;
        CompletableFuture f = WriteOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(this.advCache)).eval((Object)key, (SerializableConsumer & Serializable)view -> view.set((Object)"v2", new MetaParam.Writable[]{new MetaParam.MetaLifespan(newLifespan)}));
        AssertJUnit.assertNotNull((Object)f);
        AssertJUnit.assertFalse((boolean)f.isCancelled());
        AssertJUnit.assertNull(f.get());
        AssertJUnit.assertTrue((boolean)f.isDone());
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)"v2", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)newLifespan, (long)entry.getMetadata().lifespan());
    }

    public void testGetCustomMetadataForMortalEntries() throws Exception {
        Integer key = 5;
        CustomMetadata meta = new CustomMetadata(3000L, -1L);
        this.advCache.put((Object)key, (Object)"v1", (Metadata)meta);
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)meta, (Object)entry.getMetadata());
    }

    public void testGetCustomMetadataForTransientEntries() throws Exception {
        Integer key = 6;
        CustomMetadata meta = new CustomMetadata(-1L, 3000L);
        this.advCache.put((Object)key, (Object)"v1", (Metadata)meta);
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)meta, (Object)entry.getMetadata());
    }

    public void testGetCustomMetadataForTransientMortalEntries() throws Exception {
        Integer key = 6;
        CustomMetadata meta = new CustomMetadata(3000L, 3000L);
        this.advCache.put((Object)key, (Object)"v1", (Metadata)meta);
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)meta, (Object)entry.getMetadata());
    }

    public void testReplaceWithVersion() {
        Integer key = 7;
        NumericVersion version = new NumericVersion(1L);
        this.advCache.put((Object)key, (Object)"v1", this.withVersion((EntryVersion)version));
        NumericVersion newVersion = new NumericVersion(2L);
        this.advCache.replace((Object)key, (Object)"v2", this.withVersion((EntryVersion)newVersion));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.EQUAL, (Object)newVersion.compareTo(cacheEntry.getMetadata().version()));
    }

    public void testOverrideImmortalCustomMetadata() {
        Integer key = 8;
        CustomMetadata meta = new CustomMetadata(-1L, -1L);
        this.advCache.put((Object)key, (Object)"v1", (Metadata)meta);
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)meta, (Object)entry.getMetadata());
        CustomMetadata newMeta = new CustomMetadata(120000L, 60000L);
        this.advCache.put((Object)key, (Object)"v2", (Metadata)newMeta);
        AssertJUnit.assertEquals((Object)newMeta, (Object)this.advCache.getCacheEntry((Object)key).getMetadata());
    }

    public void testOverrideMortalCustomMetadata() {
        Integer key = 9;
        CustomMetadata meta = new CustomMetadata(120000L, -1L);
        this.advCache.put((Object)key, (Object)"v1", (Metadata)meta);
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)meta, (Object)entry.getMetadata());
        CustomMetadata newMeta = new CustomMetadata(240000L, -1L);
        this.advCache.put((Object)key, (Object)"v2", (Metadata)newMeta);
        AssertJUnit.assertEquals((Object)newMeta, (Object)this.advCache.getCacheEntry((Object)key).getMetadata());
    }

    public void testOverrideTransientCustomMetadata() {
        Integer key = 10;
        CustomMetadata meta = new CustomMetadata(-1L, 120000L);
        this.advCache.put((Object)key, (Object)"v1", (Metadata)meta);
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)meta, (Object)entry.getMetadata());
        CustomMetadata newMeta = new CustomMetadata(-1L, 240000L);
        this.advCache.put((Object)key, (Object)"v2", (Metadata)newMeta);
        AssertJUnit.assertEquals((Object)newMeta, (Object)this.advCache.getCacheEntry((Object)key).getMetadata());
    }

    public void testOverrideTransientMortalCustomMetadata() {
        Integer key = 10;
        CustomMetadata meta = new CustomMetadata(60000L, 120000L);
        this.advCache.put((Object)key, (Object)"v1", (Metadata)meta);
        CacheEntry entry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)meta, (Object)entry.getMetadata());
        CustomMetadata newMeta = new CustomMetadata(120000L, 240000L);
        this.advCache.put((Object)key, (Object)"v2", (Metadata)newMeta);
        AssertJUnit.assertEquals((Object)newMeta, (Object)this.advCache.getCacheEntry((Object)key).getMetadata());
    }

    public void testPutForExternalReadWithVersion() {
        Integer key = 11;
        NumericVersion version = new NumericVersion(1L);
        this.advCache.putForExternalRead((Object)key, (Object)"v1", this.withVersion((EntryVersion)version));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)version, (Object)cacheEntry.getMetadata().version());
    }

    public void testPutForExternalReadInDecaratedCacheWithVersion() {
        Integer key = 12;
        NumericVersion version = new NumericVersion(1L);
        AdvancedCache decoratedCache = this.advCache.withFlags(Flag.SKIP_STATISTICS);
        decoratedCache.putForExternalRead((Object)key, (Object)"v1", this.withVersion((EntryVersion)version));
        CacheEntry cacheEntry = decoratedCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)version, (Object)cacheEntry.getMetadata().version());
    }

    public void testPutForExternalReadWithLifespan() {
        Integer key = 11;
        long lifespan = 1000000L;
        this.advCache.putForExternalRead((Object)key, (Object)"v1", this.withLifespan(lifespan));
        CacheEntry cacheEntry = this.advCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((long)lifespan, (long)cacheEntry.getMetadata().lifespan());
    }

    public void testPutForExternalReadInDecaratedCacheWithLifespan() {
        Integer key = 12;
        long lifespan = 1000000L;
        AdvancedCache decoratedCache = this.advCache.withFlags(Flag.SKIP_STATISTICS);
        decoratedCache.putForExternalRead((Object)key, (Object)"v1", this.withLifespan(lifespan));
        CacheEntry cacheEntry = decoratedCache.getCacheEntry((Object)key);
        AssertJUnit.assertEquals((long)lifespan, (long)cacheEntry.getMetadata().lifespan());
    }

    private Metadata withVersion(EntryVersion version) {
        return new EmbeddedMetadata.Builder().version(version).build();
    }

    private Metadata withLifespan(long lifespan) {
        return new EmbeddedMetadata.Builder().lifespan(lifespan).build();
    }

    private static class CustomMetadata
    implements Metadata,
    Metadata.Builder {
        private final long lifespan;
        private final long maxIdle;

        private CustomMetadata(long lifespan, long maxIdle) {
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
        }

        private CustomMetadata(Metadata template) {
            this.lifespan = template.lifespan();
            this.maxIdle = template.maxIdle();
        }

        public long lifespan() {
            return this.lifespan;
        }

        public long maxIdle() {
            return this.maxIdle;
        }

        public EntryVersion version() {
            return null;
        }

        public Metadata.Builder builder() {
            return this;
        }

        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            return new CustomMetadata(unit.toMillis(time), this.maxIdle);
        }

        public Metadata.Builder lifespan(long time) {
            return this.lifespan(time, TimeUnit.MILLISECONDS);
        }

        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            return new CustomMetadata(this.lifespan, unit.toMillis(time));
        }

        public Metadata.Builder maxIdle(long time) {
            return this.maxIdle(time, TimeUnit.MILLISECONDS);
        }

        public Metadata.Builder version(EntryVersion version) {
            return this;
        }

        public Metadata build() {
            return this;
        }

        public Metadata.Builder merge(Metadata metadata) {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomMetadata that = (CustomMetadata)o;
            if (this.lifespan != that.lifespan) {
                return false;
            }
            return this.maxIdle == that.maxIdle;
        }

        public int hashCode() {
            int result = (int)(this.lifespan ^ this.lifespan >>> 32);
            result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
            return result;
        }

        public String toString() {
            return "CustomMetadata{lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + "}";
        }
    }
}

