/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac.statetransfer;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.ManualIracManager;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="irac.statetransfer.IracLocalStateTransferTest")
public class IracLocalStateTransferTest
extends AbstractXSiteTest {
    private static final String LON = "LON-1";
    private static final String NYC = "NYC-2";
    private static final int NUM_NODES = 3;
    private final ControlledConsistentHashFactory<?> lonCHF = new ControlledConsistentHashFactory.Default(0, 1);
    private final ControlledConsistentHashFactory<?> nycCHF = new ControlledConsistentHashFactory.Default(0, 1);
    private TxMode lonTxMode;

    @Factory
    public Object[] factory() {
        LinkedList<IracLocalStateTransferTest> tests = new LinkedList<IracLocalStateTransferTest>();
        for (TxMode lon : TxMode.values()) {
            tests.add(new IracLocalStateTransferTest().setLonTxMode(lon));
        }
        return tests.toArray();
    }

    public void testStateTransfer(Method method) {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.assertOwnership(key, 0);
        this.cache(LON, 0).put((Object)key, (Object)value);
        IracMetadata metadata = this.extractMetadataFromPrimaryOwner(key);
        this.assertEventuallyInSite(NYC, cache -> value.equals(cache.get((Object)key)), 30L, TimeUnit.SECONDS);
        this.changeOwnership(LON, 3);
        this.addNewNode(this.site(LON));
        this.site(LON).waitForClusterToForm(null);
        this.assertOwnership(key, 3);
        this.assertInDataContainer(LON, key, value, metadata);
    }

    public void testBackupSendAfterPrimaryFail(Method method) {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.assertOwnership(key, 0);
        ManualIracManager iracManager = ManualIracManager.wrapCache(this.cache(LON, 0));
        iracManager.enable();
        this.cache(LON, 0).put((Object)key, (Object)value);
        IracMetadata metadata = this.extractMetadataFromPrimaryOwner(key);
        this.assertInSite(NYC, cache -> AssertJUnit.assertNull((Object)cache.get((Object)key)));
        this.site(LON).kill(0);
        this.site(LON).waitForClusterToForm(null);
        this.assertEventuallyInSite(NYC, cache -> value.equals(cache.get((Object)key)), 30L, TimeUnit.SECONDS);
        this.assertInDataContainer(LON, key, value, metadata);
        this.assertInDataContainer(NYC, key, value, metadata);
    }

    public void testBackupRemovedKeySendAfterPrimaryFail(Method method) {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.assertOwnership(key, 0);
        this.cache(LON, 0).put((Object)key, (Object)value);
        this.assertEventuallyInSite(NYC, cache -> value.equals(cache.get((Object)key)), 30L, TimeUnit.SECONDS);
        ManualIracManager iracManager = ManualIracManager.wrapCache(this.cache(LON, 0));
        iracManager.enable();
        this.cache(LON, 0).remove((Object)key);
        this.assertInSite(NYC, cache -> AssertJUnit.assertEquals((Object)value, (Object)cache.get((Object)key)));
        this.site(LON).kill(0);
        this.site(LON).waitForClusterToForm(null);
        this.assertEventuallyInSite(NYC, cache -> cache.get((Object)key) == null, 30L, TimeUnit.SECONDS);
        this.assertNotInDataContainer(LON, key);
        this.assertNotInDataContainer(NYC, key);
    }

    public void testNewPrimarySend(Method method) {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.assertOwnership(key, 0);
        ManualIracManager iracManager = ManualIracManager.wrapCache(this.cache(LON, 0));
        iracManager.enable();
        this.cache(LON, 0).put((Object)key, (Object)value);
        IracMetadata metadata = this.extractMetadataFromPrimaryOwner(key);
        this.assertInSite(NYC, cache -> AssertJUnit.assertNull((Object)cache.get((Object)key)));
        this.changeOwnership(LON, 3);
        this.addNewNode(this.site(LON));
        this.site(LON).waitForClusterToForm(null);
        this.assertEventuallyInSite(NYC, cache -> value.equals(cache.get((Object)key)), 30L, TimeUnit.SECONDS);
        this.assertInDataContainer(LON, key, value, metadata);
        this.assertInDataContainer(NYC, key, value, metadata);
    }

    public void testNewPrimarySendRemovedKey(Method method) {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.assertOwnership(key, 0);
        this.cache(LON, 0).put((Object)key, (Object)value);
        this.assertEventuallyInSite(NYC, cache -> value.equals(cache.get((Object)key)), 30L, TimeUnit.SECONDS);
        ManualIracManager iracManager = ManualIracManager.wrapCache(this.cache(LON, 0));
        iracManager.enable();
        this.cache(LON, 0).remove((Object)key);
        this.assertInSite(NYC, cache -> AssertJUnit.assertEquals((Object)value, (Object)cache.get((Object)key)));
        this.changeOwnership(LON, 3);
        this.addNewNode(this.site(LON));
        this.site(LON).waitForClusterToForm(null);
        this.assertEventuallyInSite(NYC, cache -> cache.get((Object)key) == null, 30L, TimeUnit.SECONDS);
        this.assertNotInDataContainer(LON, key);
        this.assertNotInDataContainer(NYC, key);
    }

    @Override
    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() {
        super.createBeforeMethod();
        this.changeOwnership(LON, 0);
        this.changeOwnership(NYC, 0);
        for (AbstractXSiteTest.TestSite site : this.sites) {
            int numNodes = site.cacheManagers().size();
            if (numNodes > 3) {
                this.removeExtraNodes(site);
                continue;
            }
            if (numNodes >= 3) continue;
            this.addMissingNodes(site);
        }
        this.resetIracManager(LON);
        this.resetIracManager(NYC);
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"LON"};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.lonTxMode};
    }

    @Override
    protected void createSites() {
        GlobalConfigurationBuilder lonGCB = this.globalConfigurationBuilderForSite();
        AbstractXSiteTest.TestSite lon = this.addSite(LON);
        for (int i = 0; i < 3; ++i) {
            ConfigurationBuilder builder = this.getLonActiveConfig();
            lon.addCache(lonGCB, builder);
        }
        GlobalConfigurationBuilder nycGCB = this.globalConfigurationBuilderForSite();
        AbstractXSiteTest.TestSite nyc = this.addSite(NYC);
        for (int i = 0; i < 3; ++i) {
            ConfigurationBuilder builder = this.getNycActiveConfig();
            nyc.addCache(nycGCB, builder);
        }
        lon.waitForClusterToForm(null);
        nyc.waitForClusterToForm(null);
    }

    private IracLocalStateTransferTest setLonTxMode(TxMode txMode) {
        this.lonTxMode = txMode;
        return this;
    }

    private void resetIracManager(String site) {
        for (Cache cache : this.caches(site)) {
            IracManager manager = TestingUtil.extractComponent(cache, IracManager.class);
            if (!(manager instanceof ManualIracManager)) continue;
            ((ManualIracManager)manager).disable(ManualIracManager.DisableMode.DROP);
        }
    }

    private void assertOwnership(String key, int primaryOwner) {
        AssertJUnit.assertTrue((boolean)this.getDistributionForKey(this.cache(LON, primaryOwner), key).isPrimary());
        AssertJUnit.assertTrue((boolean)this.getDistributionForKey(this.cache(LON, 1), key).isWriteBackup());
    }

    private void assertInDataContainer(String site, String key, String value, IracMetadata metadata) {
        for (Cache cache : this.caches(site)) {
            if (this.isNotWriteOwner(cache, key)) continue;
            InternalDataContainer<String, String> dc = this.getInternalDataContainer(cache);
            InternalCacheEntry ice = dc.peek((Object)key);
            log.debugf("Checking DataContainer in %s. entry=%s", (Object)DistributionTestHelper.addressOf(cache), (Object)ice);
            AssertJUnit.assertNotNull((String)String.format("Internal entry is null for key %s", key), (Object)ice);
            AssertJUnit.assertEquals((String)"Internal entry wrong key", (String)key, (String)((String)ice.getKey()));
            AssertJUnit.assertEquals((String)"Internal entry wrong value", (String)value, (String)((String)ice.getValue()));
            AssertJUnit.assertEquals((String)"Internal entry wrong metadata", (Object)metadata, (Object)ice.getInternalMetadata().iracMetadata());
        }
    }

    private void assertNotInDataContainer(String site, String key) {
        for (Cache cache : this.caches(site)) {
            if (this.isNotWriteOwner(cache, key)) continue;
            InternalDataContainer<String, String> dc = this.getInternalDataContainer(cache);
            InternalCacheEntry ice = dc.peek((Object)key);
            log.debugf("Checking DataContainer in %s. entry=%s", (Object)DistributionTestHelper.addressOf(cache), (Object)ice);
            AssertJUnit.assertNull((String)String.format("Internal entry found for key %s", key), (Object)ice);
        }
    }

    private boolean isNotWriteOwner(Cache<String, String> cache, String key) {
        return !this.getDistributionForKey(cache, key).isWriteOwner();
    }

    private IracMetadata extractMetadataFromPrimaryOwner(String key) {
        Cache<String, String> cache = this.findPrimaryOwner(key);
        InternalDataContainer<String, String> dataContainer = this.getInternalDataContainer(cache);
        InternalCacheEntry entry = dataContainer.peek((Object)key);
        AssertJUnit.assertNotNull((Object)entry);
        PrivateMetadata internalMetadata = entry.getInternalMetadata();
        AssertJUnit.assertNotNull((Object)internalMetadata);
        IracMetadata metadata = internalMetadata.iracMetadata();
        AssertJUnit.assertNotNull((Object)metadata);
        return metadata;
    }

    private InternalDataContainer<String, String> getInternalDataContainer(Cache<String, String> cache) {
        return TestingUtil.extractComponent(cache, InternalDataContainer.class);
    }

    private Cache<String, String> findPrimaryOwner(String key) {
        for (Cache c : this.caches(LON)) {
            if (!this.getDistributionForKey(c, key).isPrimary()) continue;
            return c;
        }
        throw new IllegalStateException(String.format("Unable to find primary owner for key %s", key));
    }

    private DistributionInfo getDistributionForKey(Cache<String, String> cache, String key) {
        return TestingUtil.extractComponent(cache, ClusteringDependentLogic.class).getCacheTopology().getDistribution((Object)key);
    }

    private void removeExtraNodes(AbstractXSiteTest.TestSite site) {
        int numNodes = site.cacheManagers().size();
        while (numNodes > 3) {
            site.kill(--numNodes);
        }
        site.waitForClusterToForm(null);
    }

    private void addMissingNodes(AbstractXSiteTest.TestSite site) {
        for (int numNodes = site.cacheManagers().size(); numNodes < 3; ++numNodes) {
            this.addNewNode(site);
        }
        site.waitForClusterToForm(null);
    }

    private void addNewNode(AbstractXSiteTest.TestSite site) {
        String siteName = site.getSiteName();
        GlobalConfigurationBuilder gBuilder = this.globalConfigurationBuilderForSite();
        ConfigurationBuilder builder = LON.equals(siteName) ? this.getLonActiveConfig() : this.getNycActiveConfig();
        site.addCache(gBuilder, builder);
    }

    private void changeOwnership(String site, int primaryOwner) {
        ControlledConsistentHashFactory<?> chf = LON.equals(site) ? this.lonCHF : this.nycCHF;
        chf.setOwnerIndexes(primaryOwner, 1);
    }

    private GlobalConfigurationBuilder globalConfigurationBuilderForSite() {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        return builder;
    }

    private ConfigurationBuilder getNycActiveConfig() {
        ConfigurationBuilder builder = IracLocalStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        builder.clustering().hash().consistentHashFactory(this.nycCHF).numSegments(1);
        return builder;
    }

    private ConfigurationBuilder getLonActiveConfig() {
        ConfigurationBuilder builder = this.lonTxMode.create();
        BackupConfigurationBuilder lonBackupConfigurationBuilder = builder.sites().addBackup();
        lonBackupConfigurationBuilder.site(NYC).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        builder.clustering().hash().consistentHashFactory(this.lonCHF).numSegments(1);
        return builder;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum TxMode {
        NON_TX{

            @Override
            ConfigurationBuilder create() {
                return AbstractCacheTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
            }
        }
        ,
        OPT_TX{

            @Override
            ConfigurationBuilder create() {
                ConfigurationBuilder builder = AbstractCacheTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
                builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
                return builder;
            }
        }
        ,
        PES_TX{

            @Override
            ConfigurationBuilder create() {
                ConfigurationBuilder builder = AbstractCacheTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
                builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
                builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
                return builder;
            }
        };


        abstract ConfigurationBuilder create();
    }
}

