/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.AbstractDelegatingTransport;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.util.NotifierLatch;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.GlobalXSiteAdminOperations;
import org.infinispan.xsite.XSiteAdminOperations;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.infinispan.xsite.commands.remote.XSiteStatePushRequest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@CleanupAfterTest
@Test(groups={"xsite"}, testName="xsite.GlobalXSiteAdminOpsTest")
public class GlobalXSiteAdminOpsTest
extends AbstractMultipleSitesTest {
    protected static ConfigurationBuilder newConfiguration() {
        return GlobalXSiteAdminOpsTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
    }

    public void testTakeSiteOffline(Method m) {
        String key = TestingUtil.k(m);
        String value = TestingUtil.v(m);
        this.assertAllCachesEmpty();
        this.assertSiteStatusInAllCaches("online");
        TestingUtil.extractGlobalComponent((CacheContainer)this.site(0).cacheManagers().get(0), GlobalXSiteAdminOperations.class).takeSiteOffline(this.siteName(1));
        this.assertSiteStatus(null, 1, "offline");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 1, "offline");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 2, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_2.name(), 2, "online");
        this.putInAllCache(key, value);
        this.assertValueInAllCachesInPrimarySite(key, value);
        this.assertCacheEmpty(1, null);
        this.assertCacheEmpty(1, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertValueInCache(2, CacheType.BACKUP_TO_SITE_1_AND_2.name(), key, value);
        this.assertValueInCache(2, CacheType.BACKUP_TO_SITE_2.name(), key, value);
    }

    public void testBringSiteOnline(Method m) {
        String key = TestingUtil.k(m);
        String value = TestingUtil.v(m);
        this.assertAllCachesEmpty();
        this.setSitesStatus(false);
        this.assertSiteStatusInAllCaches("offline");
        TestingUtil.extractGlobalComponent((CacheContainer)this.site(0).cacheManagers().get(0), GlobalXSiteAdminOperations.class).bringSiteOnline(this.siteName(1));
        this.assertSiteStatus(null, 1, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 1, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 2, "offline");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_2.name(), 2, "offline");
        this.putInAllCache(key, value);
        this.assertValueInAllCachesInPrimarySite(key, value);
        this.assertValueInCache(1, null, key, value);
        this.assertValueInCache(1, CacheType.BACKUP_TO_SITE_1_AND_2.name(), key, value);
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_2.name());
    }

    public void testPushState(Method m) {
        String key = TestingUtil.k(m);
        String value = TestingUtil.v(m);
        this.assertAllCachesEmpty();
        this.setSitesStatus(false);
        this.assertSiteStatusInAllCaches("offline");
        this.putInAllCache(key, value);
        this.assertValueInAllCachesInPrimarySite(key, value);
        this.assertCacheEmpty(1, null);
        this.assertCacheEmpty(1, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_2.name());
        TestingUtil.extractGlobalComponent((CacheContainer)this.site(0).cacheManagers().get(0), GlobalXSiteAdminOperations.class).pushState(this.siteName(1));
        this.awaitXSiteStateTransfer();
        this.assertSiteStatus(null, 1, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 1, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 2, "offline");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_2.name(), 2, "offline");
        this.assertValueInCache(1, null, key, value);
        this.assertValueInCache(1, CacheType.BACKUP_TO_SITE_1_AND_2.name(), key, value);
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_2.name());
        TestingUtil.extractGlobalComponent((CacheContainer)this.site(0).cacheManagers().get(0), GlobalXSiteAdminOperations.class).pushState(this.siteName(2));
        this.awaitXSiteStateTransfer();
        this.assertSiteStatus(null, 1, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 1, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 2, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_2.name(), 2, "online");
        this.assertValueInCache(1, null, key, value);
        this.assertValueInCache(1, CacheType.BACKUP_TO_SITE_1_AND_2.name(), key, value);
        this.assertValueInCache(2, CacheType.BACKUP_TO_SITE_1_AND_2.name(), key, value);
        this.assertValueInCache(2, CacheType.BACKUP_TO_SITE_2.name(), key, value);
    }

    public void testCancelPushState(Method m) {
        String key = TestingUtil.k(m);
        String value = TestingUtil.v(m);
        this.assertAllCachesEmpty();
        this.setSitesStatus(false);
        this.assertSiteStatusInAllCaches("offline");
        this.putInAllCache(key, value);
        this.assertValueInAllCachesInPrimarySite(key, value);
        this.assertCacheEmpty(1, null);
        this.assertCacheEmpty(1, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_2.name());
        List<BlockingTransport> blockingTransportList = this.getBlockingTransport(true);
        blockingTransportList.forEach(BlockingTransport::blockCommands);
        TestingUtil.extractGlobalComponent((CacheContainer)this.site(0).cacheManagers().get(0), GlobalXSiteAdminOperations.class).pushState(this.siteName(1));
        TestingUtil.extractGlobalComponent((CacheContainer)this.site(0).cacheManagers().get(0), GlobalXSiteAdminOperations.class).cancelPushState(this.siteName(1));
        this.assertSiteStatus(null, 1, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 1, "online");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 2, "offline");
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_2.name(), 2, "offline");
        this.assertCacheEmpty(1, null);
        this.assertCacheEmpty(1, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_2.name());
        blockingTransportList.forEach(BlockingTransport::unblockCommands);
    }

    @AfterMethod(alwaysRun=true)
    public void resetStatusAfterMethod() {
        this.setSitesStatus(true);
        this.getBlockingTransport(false).forEach(BlockingTransport::unblockCommands);
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        if (siteIndex == 0) {
            ConfigurationBuilder builder = GlobalXSiteAdminOpsTest.newConfiguration();
            builder.sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.SYNC);
            return builder;
        }
        return GlobalXSiteAdminOpsTest.newConfiguration();
    }

    @Override
    protected int defaultNumberOfSites() {
        return 3;
    }

    @Override
    protected void afterSitesCreated() {
        super.afterSitesCreated();
        ConfigurationBuilder builder = GlobalXSiteAdminOpsTest.newConfiguration();
        builder.sites().addBackup().site(this.siteName(2)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        GlobalXSiteAdminOpsTest.defineInSite(this.site(0), CacheType.BACKUP_TO_SITE_2.name(), builder.build());
        GlobalXSiteAdminOpsTest.defineInSite(this.site(2), CacheType.BACKUP_TO_SITE_2.name(), GlobalXSiteAdminOpsTest.newConfiguration().build());
        builder = GlobalXSiteAdminOpsTest.newConfiguration();
        builder.sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        builder.sites().addBackup().site(this.siteName(2)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        GlobalXSiteAdminOpsTest.defineInSite(this.site(0), CacheType.BACKUP_TO_SITE_1_AND_2.name(), builder.build());
        GlobalXSiteAdminOpsTest.defineInSite(this.site(1), CacheType.BACKUP_TO_SITE_1_AND_2.name(), GlobalXSiteAdminOpsTest.newConfiguration().build());
        GlobalXSiteAdminOpsTest.defineInSite(this.site(2), CacheType.BACKUP_TO_SITE_1_AND_2.name(), GlobalXSiteAdminOpsTest.newConfiguration().build());
        GlobalXSiteAdminOpsTest.defineInSite(this.site(0), CacheType.NO_BACKUP.name(), GlobalXSiteAdminOpsTest.newConfiguration().build());
        this.site(0).waitForClusterToForm(null);
        this.site(0).waitForClusterToForm(CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.site(0).waitForClusterToForm(CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.site(0).waitForClusterToForm(CacheType.BACKUP_TO_SITE_2.name());
        this.site(1).waitForClusterToForm(null);
        this.site(1).waitForClusterToForm(CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.site(2).waitForClusterToForm(CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.site(2).waitForClusterToForm(CacheType.BACKUP_TO_SITE_2.name());
    }

    private void awaitXSiteStateTransfer() {
        this.awaitXSiteStateTransferFor(null);
        this.awaitXSiteStateTransferFor(CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.awaitXSiteStateTransferFor(CacheType.BACKUP_TO_SITE_2.name());
    }

    private void awaitXSiteStateTransferFor(String cacheName) {
        this.eventually(String.format("Failed to complete the x-site state transfer for cache '%s'", cacheName), () -> this.xSiteAdminOperations(cacheName).getRunningStateTransfer().isEmpty());
    }

    private void setSitesStatus(boolean online) {
        if (online) {
            this.xSiteAdminOperations(null).bringSiteOnline(this.siteName(1));
            this.xSiteAdminOperations(CacheType.BACKUP_TO_SITE_1_AND_2.name()).bringSiteOnline(this.siteName(1));
            this.xSiteAdminOperations(CacheType.BACKUP_TO_SITE_1_AND_2.name()).bringSiteOnline(this.siteName(2));
            this.xSiteAdminOperations(CacheType.BACKUP_TO_SITE_2.name()).bringSiteOnline(this.siteName(2));
        } else {
            this.xSiteAdminOperations(null).takeSiteOffline(this.siteName(1));
            this.xSiteAdminOperations(CacheType.BACKUP_TO_SITE_1_AND_2.name()).takeSiteOffline(this.siteName(1));
            this.xSiteAdminOperations(CacheType.BACKUP_TO_SITE_1_AND_2.name()).takeSiteOffline(this.siteName(2));
            this.xSiteAdminOperations(CacheType.BACKUP_TO_SITE_2.name()).takeSiteOffline(this.siteName(2));
        }
    }

    private void putInAllCache(String key, String value) {
        this.cache(0, 0, null).put((Object)key, (Object)value);
        this.cache(0, 0, CacheType.BACKUP_TO_SITE_1_AND_2.name()).put((Object)key, (Object)value);
        this.cache(0, 0, CacheType.BACKUP_TO_SITE_2.name()).put((Object)key, (Object)value);
        this.cache(0, 0, CacheType.NO_BACKUP.name()).put((Object)key, (Object)value);
    }

    private void assertValueInAllCachesInPrimarySite(String key, String value) {
        this.assertValueInCache(0, null, key, value);
        this.assertValueInCache(0, CacheType.BACKUP_TO_SITE_1_AND_2.name(), key, value);
        this.assertValueInCache(0, CacheType.BACKUP_TO_SITE_2.name(), key, value);
        this.assertValueInCache(0, CacheType.NO_BACKUP.name(), key, value);
    }

    private void assertValueInCache(int siteIndex, String cacheName, String key, String value) {
        for (int nodeIndex = 0; nodeIndex < this.defaultNumberOfNodes(); ++nodeIndex) {
            AssertJUnit.assertEquals((String)String.format("Wrong value for key '%s' in cache '%s' on site '%d' and node '%d'", key, cacheName, siteIndex, nodeIndex), (Object)value, (Object)this.cache(siteIndex, nodeIndex, cacheName).get((Object)key));
        }
    }

    private XSiteAdminOperations xSiteAdminOperations(String cacheName) {
        return TestingUtil.extractComponent(this.cache(0, 0, cacheName), XSiteAdminOperations.class);
    }

    private void assertCacheEmpty(int siteIndex, String cacheName) {
        AssertJUnit.assertTrue((String)String.format("Cache '%s' is not empty in site '%d'", this.cache(siteIndex, 0, cacheName).getName(), siteIndex), (boolean)this.cache(siteIndex, 0, cacheName).isEmpty());
    }

    private void assertAllCachesEmpty() {
        for (CacheType cacheType : CacheType.values()) {
            this.assertCacheEmpty(0, cacheType.name());
        }
        this.assertCacheEmpty(1, null);
        this.assertCacheEmpty(1, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_1_AND_2.name());
        this.assertCacheEmpty(2, CacheType.BACKUP_TO_SITE_2.name());
    }

    private void assertSiteStatusInAllCaches(String status) {
        this.assertSiteStatus(null, 1, status);
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 1, status);
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_1_AND_2.name(), 2, status);
        this.assertSiteStatus(CacheType.BACKUP_TO_SITE_2.name(), 2, status);
    }

    private void assertSiteStatus(String cacheName, int backupSiteIndex, String status) {
        AssertJUnit.assertEquals((String)String.format("Wrong site status for cache '%s' for backup site '%d'.", cacheName, backupSiteIndex), (String)status, (String)this.xSiteAdminOperations(cacheName).siteStatus(this.siteName(backupSiteIndex)));
    }

    private List<BlockingTransport> getBlockingTransport(boolean createIfAbsent) {
        List<EmbeddedCacheManager> cacheManagerList = this.site(0).cacheManagers();
        ArrayList blockingTransportList = new ArrayList(cacheManagerList.size());
        cacheManagerList.forEach(cacheManager -> {
            Transport transport = (Transport)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)cacheManager, Transport.class);
            if (transport instanceof BlockingTransport) {
                blockingTransportList.add((BlockingTransport)transport);
            } else if (createIfAbsent) {
                BlockingTransport blockingTransport = new BlockingTransport(transport);
                TestingUtil.replaceComponent((CacheContainer)cacheManager, Transport.class, blockingTransport, true);
                blockingTransportList.add(blockingTransport);
            }
        });
        return blockingTransportList.isEmpty() ? Collections.emptyList() : blockingTransportList;
    }

    protected static enum CacheType {
        BACKUP_TO_SITE_2,
        BACKUP_TO_SITE_1_AND_2,
        NO_BACKUP;

    }

    static class BlockingTransport
    extends AbstractDelegatingTransport {
        private final NotifierLatch notifierLatch = new NotifierLatch(this.toString());

        public BlockingTransport(Transport actual) {
            super(actual);
            this.notifierLatch.stopBlocking();
        }

        public void blockCommands() {
            this.notifierLatch.startBlocking();
        }

        public void unblockCommands() {
            this.notifierLatch.stopBlocking();
        }

        public void start() {
        }

        public <O> XSiteResponse<O> backupRemotely(XSiteBackup backup, XSiteRequest<O> rpcCommand) {
            if (rpcCommand instanceof XSiteStatePushRequest) {
                this.notifierLatch.blockIfNeeded();
            }
            return super.backupRemotely(backup, rpcCommand);
        }

        public String toString() {
            return "BlockingTransport{actual=" + String.valueOf(this.actual) + "}";
        }
    }
}

