/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.MagicKey;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.PartitionStatusChanged;
import org.infinispan.notifications.cachelistener.event.PartitionStatusChangedEvent;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.test.concurrent.StateSequencer;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.DelayedAvailabilityUpdateTest")
public class DelayedAvailabilityUpdateTest
extends BasePartitionHandlingTest {
    public void testDelayedAvailabilityUpdate0() throws Exception {
        this.testDelayedAvailabilityUpdate(new BasePartitionHandlingTest.PartitionDescriptor(0, 1), new BasePartitionHandlingTest.PartitionDescriptor(2, 3));
    }

    public void testDelayedAvailabilityUpdate1() throws Exception {
        this.testDelayedAvailabilityUpdate(new BasePartitionHandlingTest.PartitionDescriptor(0, 2), new BasePartitionHandlingTest.PartitionDescriptor(1, 3));
    }

    public void testDelayedAvailabilityUpdate2() throws Exception {
        this.testDelayedAvailabilityUpdate(new BasePartitionHandlingTest.PartitionDescriptor(0, 3), new BasePartitionHandlingTest.PartitionDescriptor(1, 2));
    }

    public void testDelayedAvailabilityUpdate3() throws Exception {
        this.testDelayedAvailabilityUpdate(new BasePartitionHandlingTest.PartitionDescriptor(1, 2), new BasePartitionHandlingTest.PartitionDescriptor(0, 3));
    }

    public void testDelayedAvailabilityUpdate4() throws Exception {
        this.testDelayedAvailabilityUpdate(new BasePartitionHandlingTest.PartitionDescriptor(1, 3), new BasePartitionHandlingTest.PartitionDescriptor(0, 2));
    }

    public void testDelayedAvailabilityUpdate5() throws Exception {
        this.testDelayedAvailabilityUpdate(new BasePartitionHandlingTest.PartitionDescriptor(2, 3), new BasePartitionHandlingTest.PartitionDescriptor(0, 1));
    }

    protected void testDelayedAvailabilityUpdate(BasePartitionHandlingTest.PartitionDescriptor p0, BasePartitionHandlingTest.PartitionDescriptor p1) throws Exception {
        MagicKey k0Existing = new MagicKey("k0Existing", this.cache(p0.node(0)), this.cache(p0.node(1)));
        MagicKey k1Existing = new MagicKey("k1Existing", this.cache(p0.node(1)), this.cache(p1.node(0)));
        MagicKey k2Existing = new MagicKey("k2Existing", this.cache(p1.node(0)), this.cache(p1.node(1)));
        MagicKey k3Existing = new MagicKey("k3Existing", this.cache(p1.node(1)), this.cache(p0.node(0)));
        MagicKey k0Missing = new MagicKey("k0Missing", this.cache(p0.node(0)), this.cache(p0.node(1)));
        MagicKey k1Missing = new MagicKey("k1Missing", this.cache(p0.node(1)), this.cache(p1.node(0)));
        MagicKey k2Missing = new MagicKey("k2Missing", this.cache(p1.node(0)), this.cache(p1.node(1)));
        MagicKey k3Missing = new MagicKey("k3Missing", this.cache(p1.node(1)), this.cache(p0.node(0)));
        Cache cacheP0N0 = this.cache(p0.node(0));
        cacheP0N0.put((Object)k0Existing, (Object)"v0");
        cacheP0N0.put((Object)k1Existing, (Object)"v1");
        cacheP0N0.put((Object)k2Existing, (Object)"v2");
        cacheP0N0.put((Object)k3Existing, (Object)"v3");
        StateSequencer ss = new StateSequencer();
        ss.logicalThread("main", "main:block_availability_update_p0n0", "main:after_availability_update_p0n1", "main:check_availability", "main:resume_availability_update_p0n0");
        log.debugf("Delaying the availability mode update on node %s", (Object)this.address(p0.node(0)));
        this.cache(p0.node(0)).addListener((Object)new BlockAvailabilityChangeListener(true, ss, "main:block_availability_update_p0n0", "main:resume_availability_update_p0n0"));
        this.cache(p0.node(1)).addListener((Object)new BlockAvailabilityChangeListener(false, ss, "main:after_availability_update_p0n1"));
        this.splitCluster(p0.getNodes(), p1.getNodes());
        ss.enter("main:check_availability");
        DistributionManager dmP0N1 = this.advancedCache(p0.node(1)).getDistributionManager();
        this.eventuallyEquals(2, () -> dmP0N1.getCacheTopology().getActualMembers().size());
        Assert.assertEquals((Object)AvailabilityMode.AVAILABLE, (Object)this.partitionHandlingManager(p0.node(0)).getAvailabilityMode());
        this.assertKeyAvailableForRead(cacheP0N0, k0Existing, "v0");
        this.assertKeyAvailableForRead(cacheP0N0, k3Existing, "v3");
        this.partition(0).assertKeyAvailableForRead(k0Missing, null);
        this.assertKeyAvailableForRead(cacheP0N0, k3Missing, null);
        this.assertKeyNotAvailableForRead(cacheP0N0, k1Existing);
        this.assertKeyNotAvailableForRead(cacheP0N0, k1Missing);
        Future<Object> getK2Existing = this.fork(() -> cacheP0N0.get(k2Existing));
        Future<Map> getAllK2Existing = this.fork(() -> cacheP0N0.getAdvancedCache().getAll(Collections.singleton(k2Existing)));
        Future<Object> getK2Missing = this.fork(() -> cacheP0N0.get(k2Missing));
        Future<Map> getAllK2Missing = this.fork(() -> cacheP0N0.getAdvancedCache().getAll(Collections.singleton(k2Missing)));
        Thread.sleep(50L);
        AssertJUnit.assertFalse((boolean)getK2Existing.isDone());
        AssertJUnit.assertFalse((boolean)getAllK2Existing.isDone());
        AssertJUnit.assertFalse((boolean)getK2Missing.isDone());
        AssertJUnit.assertFalse((boolean)getAllK2Missing.isDone());
        ss.exit("main:check_availability");
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
        Exceptions.expectExecutionException(AvailabilityException.class, getK2Existing);
        Exceptions.expectExecutionException(AvailabilityException.class, getAllK2Existing);
        Exceptions.expectExecutionException(AvailabilityException.class, getK2Missing);
        Exceptions.expectExecutionException(AvailabilityException.class, getAllK2Missing);
    }

    @Listener
    public static class BlockAvailabilityChangeListener {
        private final boolean blockPre;
        private final StateSequencer ss;
        private final String[] states;

        BlockAvailabilityChangeListener(boolean blockPre, StateSequencer ss, String ... states) {
            this.blockPre = blockPre;
            this.ss = ss;
            this.states = states;
        }

        @PartitionStatusChanged
        public void onPartitionStatusChange(PartitionStatusChangedEvent e) throws Exception {
            if (this.blockPre == e.isPre()) {
                for (String state : this.states) {
                    this.ss.advance(state);
                }
            }
        }
    }
}

