/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHashFactory;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.distribution.ch.impl.SyncReplicatedConsistentHashFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.op.TestFunctionalWriteOperation;
import org.infinispan.test.op.TestOperation;
import org.infinispan.test.op.TestWriteOperation;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.ClusterTopologyManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="distribution.ch.ZeroCapacityNodeTest")
public class ZeroCapacityNodeTest
extends MultipleCacheManagersTest {
    public static final int NUM_SEGMENTS = 60;
    private EmbeddedCacheManager node1;
    private EmbeddedCacheManager node2;
    private EmbeddedCacheManager zeroCapacityNode;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.node1 = this.addClusterEnabledCacheManager();
        this.node2 = this.addClusterEnabledCacheManager();
        GlobalConfigurationBuilder zeroCapacityBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder().zeroCapacityNode(true);
        this.zeroCapacityNode = this.addClusterEnabledCacheManager(zeroCapacityBuilder, null);
    }

    @DataProvider(name="cm_chf")
    protected Object[][] consistentHashFactory() {
        return new Object[][]{{CacheMode.DIST_SYNC, new DefaultConsistentHashFactory()}, {CacheMode.DIST_SYNC, new SyncConsistentHashFactory()}, {CacheMode.REPL_SYNC, new ReplicatedConsistentHashFactory()}, {CacheMode.REPL_SYNC, new SyncReplicatedConsistentHashFactory()}};
    }

    @Test(dataProvider="cm_chf")
    public void testCapacityFactors(CacheMode cacheMode, ConsistentHashFactory<?> consistentHashFactory) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(cacheMode);
        cb.clustering().hash().numSegments(60).consistentHashFactory(consistentHashFactory);
        cb.clustering().hash().capacityFactor(1.0f);
        String cacheName = String.valueOf(cacheMode) + String.valueOf(consistentHashFactory);
        this.createCache(cb, cacheName);
        Cache cache1 = this.node1.getCache(cacheName);
        Cache cache2 = this.node2.getCache(cacheName);
        Cache zeroCapacityCache = this.zeroCapacityNode.getCache(cacheName);
        ConsistentHash ch = TestingUtil.extractCacheTopology(cache1).getReadConsistentHash();
        AssertJUnit.assertEquals((double)1.0, (double)this.capacityFactor(ch, this.node1).floatValue(), (double)0.0);
        AssertJUnit.assertEquals((double)1.0, (double)this.capacityFactor(ch, this.node2).floatValue(), (double)0.0);
        AssertJUnit.assertEquals((double)0.0, (double)this.capacityFactor(ch, this.zeroCapacityNode).floatValue(), (double)0.0);
        AssertJUnit.assertEquals(Collections.emptySet(), (Object)ch.getPrimarySegmentsForOwner(this.zeroCapacityNode.getAddress()));
        AssertJUnit.assertEquals(Collections.emptySet(), (Object)ch.getSegmentsForOwner(this.zeroCapacityNode.getAddress()));
        cache1.stop();
        ConsistentHash ch2 = TestingUtil.extractCacheTopology(cache2).getReadConsistentHash();
        AssertJUnit.assertEquals(Collections.emptySet(), (Object)ch2.getPrimarySegmentsForOwner(this.zeroCapacityNode.getAddress()));
        AssertJUnit.assertEquals(Collections.emptySet(), (Object)ch2.getSegmentsForOwner(this.zeroCapacityNode.getAddress()));
        zeroCapacityCache.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)zeroCapacityCache.get((Object)"key"));
    }

    public void testReplicatedWriteOperations() {
        String cacheName = "replConditional";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC);
        this.createCache(builder, cacheName);
        for (TestWriteOperation testWriteOperation : TestWriteOperation.values()) {
            this.doTestReplicatedWriteOperation(cacheName, testWriteOperation);
        }
        for (Enum enum_ : TestFunctionalWriteOperation.values()) {
            this.doTestReplicatedWriteOperation(cacheName, (TestOperation)((Object)enum_));
        }
    }

    private void doTestReplicatedWriteOperation(String cacheName, TestOperation op) {
        log.debugf("Testing %s", (Object)op);
        for (Cache cache : this.caches(cacheName)) {
            String key = String.format("key-%s-%s", op, this.address(cache));
            op.insertPreviousValue((AdvancedCache<Object, Object>)cache.getAdvancedCache(), key);
            Object result = op.perform((AdvancedCache<Object, Object>)cache.getAdvancedCache(), key);
            AssertJUnit.assertEquals((Object)op.getReturnValue(), (Object)result);
            cache.clear();
            AssertJUnit.assertTrue((boolean)cache.isEmpty());
        }
    }

    public void testReplicatedClusteredListener() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.REPL_SYNC);
        cb.clustering().hash().numSegments(60);
        cb.clustering().hash().capacityFactor(1.0f);
        String cacheName = "replicated_clustered_listener";
        this.createCache(cb, cacheName);
        ClusteredListener listener = new ClusteredListener();
        this.zeroCapacityNode.getCache(cacheName).addListener((Object)listener);
        this.zeroCapacityNode.getCache(cacheName).put((Object)"key1", (Object)"value1");
        AssertJUnit.assertEquals((int)1, (int)listener.events.get());
        this.node1.getCache(cacheName).put((Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((int)2, (int)listener.events.get());
    }

    private void createCache(ConfigurationBuilder cb, String cacheName) {
        this.node1.createCache(cacheName, cb.build());
        this.node2.createCache(cacheName, cb.build());
        this.zeroCapacityNode.createCache(cacheName, cb.build());
        this.waitForClusterToForm(cacheName);
    }

    public void testZeroCapacityFactorNodeStartsFirst(Method m) throws Exception {
        String cacheName = m.getName();
        LinkedBlockingQueue joinResponses = new LinkedBlockingQueue();
        AssertJUnit.assertTrue((boolean)this.node1.isCoordinator());
        ClusterTopologyManager originalCTM = TestingUtil.extractGlobalComponent((CacheContainer)this.node1, ClusterTopologyManager.class);
        Answer delegateAnswer = invocation -> invocation.getMethod().invoke((Object)originalCTM, invocation.getArguments());
        ClusterTopologyManager trackingCTM = (ClusterTopologyManager)Mockito.mock(ClusterTopologyManager.class, (Answer)delegateAnswer);
        Mockito.when((Object)trackingCTM.handleJoin((String)ArgumentMatchers.eq((Object)cacheName), (Address)ArgumentMatchers.any(), (CacheJoinInfo)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenAnswer(invocation -> originalCTM.handleJoin(cacheName, (Address)invocation.getArgument(1), (CacheJoinInfo)invocation.getArgument(2), ((Integer)invocation.getArgument(3)).intValue()).thenApply(r -> {
            joinResponses.offer(r);
            return r;
        }));
        TestingUtil.replaceComponent((CacheContainer)this.node1, ClusterTopologyManager.class, trackingCTM, true);
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numSegments(60);
        ConfigurationBuilder cbZero = new ConfigurationBuilder();
        cbZero.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numSegments(60).capacityFactor(0.0f);
        Future<Cache> zeroCapacityNodeFuture = this.fork(() -> this.zeroCapacityNode.createCache(cacheName, cb.build()));
        Future<Cache> node1Future = this.fork(() -> this.node1.createCache(cacheName, cbZero.build()));
        AssertJUnit.assertFalse((boolean)zeroCapacityNodeFuture.isDone());
        AssertJUnit.assertFalse((boolean)node1Future.isDone());
        AssertJUnit.assertEquals((int)0, (int)joinResponses.size());
        this.node2.createCache(cacheName, cb.build());
        node1Future.get(10L, TimeUnit.SECONDS);
        zeroCapacityNodeFuture.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)3, (int)joinResponses.size());
        while (!joinResponses.isEmpty()) {
            CacheStatusResponse joinResponse = (CacheStatusResponse)joinResponses.poll();
            AssertJUnit.assertTrue((boolean)joinResponse.getCacheTopology().getMembers().contains(this.node2.getAddress()));
        }
        this.waitForClusterToForm(cacheName);
        ConsistentHash ch3 = this.consistentHash(0, cacheName);
        AssertJUnit.assertEquals((double)0.0, (double)this.capacityFactor(ch3, this.zeroCapacityNode).floatValue(), (double)0.0);
        AssertJUnit.assertEquals((double)0.0, (double)this.capacityFactor(ch3, this.node1).floatValue(), (double)0.0);
        AssertJUnit.assertEquals((double)1.0, (double)this.capacityFactor(ch3, this.node2).floatValue(), (double)0.0);
        this.cache(0, cacheName).put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache(0, cacheName).get((Object)"key"));
        TestingUtil.replaceComponent((CacheContainer)this.node1, ClusterTopologyManager.class, originalCTM, true);
    }

    public void testOnlyZeroCapacityNodesRemain(Method m) {
        String cacheName = m.getName();
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numSegments(60);
        ConfigurationBuilder cbZero = new ConfigurationBuilder();
        cbZero.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numSegments(60).capacityFactor(0.0f);
        this.node2.createCache(cacheName, cb.build());
        this.node1.createCache(cacheName, cbZero.build());
        this.zeroCapacityNode.createCache(cacheName, cb.build());
        this.waitForClusterToForm(cacheName);
        this.node2.stop();
        this.cacheManagers.remove(1);
        this.zeroCapacityNode.getCache(cacheName).getCacheConfiguration().clustering().remoteTimeout(10L);
        Exceptions.expectCompletionException(TimeoutException.class, (CompletionStage)this.zeroCapacityNode.getCache(cacheName).getAsync((Object)"key"));
        this.node2 = this.addClusterEnabledCacheManager();
        this.node2.defineConfiguration(cacheName, cb.build());
        this.node2.getCache(cacheName);
        this.zeroCapacityNode.getCache(cacheName).getCacheConfiguration().clustering().remoteTimeout(10000L);
        this.zeroCapacityNode.getCache(cacheName).get((Object)"key");
    }

    public void testDenyReadWritesCacheStaysAvailableAfterZeroCapacityNodeCrash(Method m) {
        String cacheName = m.getName();
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).hash().numSegments(60);
        ConfigurationBuilder cbZero = new ConfigurationBuilder();
        cbZero.clustering().cacheMode(CacheMode.DIST_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).hash().numSegments(60).capacityFactor(0.0f);
        this.node1.createCache(cacheName, cb.build());
        this.node2.createCache(cacheName, cbZero.build());
        this.zeroCapacityNode.createCache(cacheName, cb.build());
        this.waitForClusterToForm(cacheName);
        TestingUtil.installNewView(this.node1);
        TestingUtil.installNewView(this.node2, this.zeroCapacityNode);
        TestingUtil.waitForNoRebalance(this.node1.getCache(cacheName));
        this.cache(0, cacheName).get((Object)"key");
        TestingUtil.installNewView(this.node1, this.node2, this.zeroCapacityNode);
        TestingUtil.waitForNoRebalance(this.caches(cacheName));
        this.cache(0, cacheName).get((Object)"key");
    }

    public void testZeroCapacityMembersPreferConsistencyStrategy(Method m) {
        String cacheName = m.getName();
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.REPL_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).hash().numSegments(60);
        ConfigurationBuilder cbZero = new ConfigurationBuilder();
        cbZero.clustering().cacheMode(CacheMode.REPL_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).hash().numSegments(60).capacityFactor(0.0f);
        this.node1.createCache(cacheName, cb.build());
        this.node2.createCache(cacheName, cb.build());
        this.zeroCapacityNode.createCache(cacheName, cbZero.build());
        this.waitForClusterToForm(cacheName);
        TestingUtil.killCacheManagers(this.node1);
        this.cacheManagers.remove(this.node1);
        this.waitForClusterToForm(cacheName);
        TestingUtil.installNewView(this.node2);
        TestingUtil.waitForNoRebalance(this.node2.getCache(cacheName));
    }

    private ConsistentHash consistentHash(int managerIndex, String cacheName) {
        return this.cache(managerIndex, cacheName).getAdvancedCache().getDistributionManager().getCacheTopology().getReadConsistentHash();
    }

    private Float capacityFactor(ConsistentHash ch, EmbeddedCacheManager node) {
        return (Float)ch.getCapacityFactors().get(node.getAddress());
    }

    @Listener(clustered=true)
    private static class ClusteredListener {
        AtomicInteger events = new AtomicInteger();

        private ClusteredListener() {
        }

        @CacheEntryCreated
        public void event(Event event) throws Throwable {
            log.tracef("Received event %s", (Object)event);
            this.events.incrementAndGet();
        }
    }
}

