/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.StressTest;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="commands.PutMapCommandStressTest", timeOut=900000L)
public class PutMapCommandStressTest
extends StressTest {
    protected static final int NUM_OWNERS = 3;
    protected static final int CACHE_COUNT = 6;
    protected static final int THREAD_MULTIPLIER = 1;
    protected static final int THREAD_WORKER_COUNT = 5;
    protected static final int CACHE_ENTRY_COUNT = 50000;
    protected boolean enableStore;

    @Override
    public Object[] factory() {
        return new Object[]{new PutMapCommandStressTest().enableStore(false).cacheMode(CacheMode.DIST_SYNC).transactional(false), new PutMapCommandStressTest().enableStore(false).cacheMode(CacheMode.DIST_SYNC).transactional(true), new PutMapCommandStressTest().enableStore(true).cacheMode(CacheMode.DIST_SYNC).transactional(false), new PutMapCommandStressTest().enableStore(true).cacheMode(CacheMode.DIST_SYNC).transactional(true)};
    }

    PutMapCommandStressTest enableStore(boolean enableStore) {
        this.enableStore = enableStore;
        return this;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(this.cacheMode);
        this.builderUsed.clustering().hash().numOwners(3);
        this.builderUsed.clustering().stateTransfer().chunkSize(25000);
        this.builderUsed.clustering().remoteTimeout(12000L);
        if (this.transactional.booleanValue()) {
            this.builderUsed.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        if (this.enableStore) {
            ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)this.builderUsed.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).storeName(PutMapCommandStressTest.class.toString());
        }
        this.createClusteredCaches(6, "testCache", this.builderUsed);
    }

    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.amendGlobalConfiguration(gcb, flags);
        BlockingThreadPoolExecutorFactory executorFactory = new BlockingThreadPoolExecutorFactory(25, 25, 10000, 30000L);
        gcb.transport().transportThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)executorFactory);
        gcb.transport().remoteCommandThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)executorFactory);
        EmbeddedCacheManager cm = TestCacheManagerFactory.newDefaultCacheManager(true, gcb, new ConfigurationBuilder());
        this.cacheManagers.add(cm);
        return cm;
    }

    public void testStressNodesLeavingWhileMultiplePutMap() throws Throwable {
        int i;
        HashMap<Integer, Integer> masterValues = new HashMap<Integer, Integer>();
        Map[] keys = new Map[5];
        for (i = 0; i < keys.length; ++i) {
            keys[i] = new HashMap();
        }
        for (i = 0; i < 50000; ++i) {
            masterValues.put(i, i);
            keys[i % 5].put(i, i);
        }
        this.cache(0, "testCache").putAll(masterValues);
        for (i = 0; i < keys.length; ++i) {
            keys[i] = Collections.unmodifiableMap(keys[i]);
        }
        List<Future<Void>> futures = this.forkWorkerThreads("testCache", 1, 6, keys, (cache, keysToUse, iteration) -> cache.getAdvancedCache().putAll(keysToUse));
        futures.add(this.forkRestartingThread(6));
        this.waitAndFinish(futures, 1, TimeUnit.MINUTES);
    }
}

