/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$guava$.base;

import com.google.errorprone.annotations.DoNotMock;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.internal.$guava$.annotations.$Beta;
import org.immutables.value.internal.$guava$.annotations.$GwtCompatible;
import org.immutables.value.internal.$guava$.base.$Absent;
import org.immutables.value.internal.$guava$.base.$AbstractIterator;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Present;
import org.immutables.value.internal.$guava$.base.$Supplier;

@DoNotMock(value="Use Optional.of(value) or Optional.absent()")
@$GwtCompatible(serializable=true)
public abstract class $Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> $Optional<T> absent() {
        return $Absent.withType();
    }

    public static <T> $Optional<T> of(T reference) {
        return new $Present<T>($Preconditions.checkNotNull(reference));
    }

    public static <T> $Optional<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? $Optional.absent() : new $Present<T>(nullableReference);
    }

    public static <T> @Nullable $Optional<T> fromJavaUtil(@Nullable Optional<T> javaUtilOptional) {
        return javaUtilOptional == null ? null : $Optional.fromNullable(javaUtilOptional.orElse(null));
    }

    public static <T> @Nullable Optional<T> toJavaUtil(@Nullable $Optional<T> googleOptional) {
        return googleOptional == null ? null : googleOptional.toJavaUtil();
    }

    public Optional<T> toJavaUtil() {
        return Optional.ofNullable(this.orNull());
    }

    $Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract $Optional<T> or($Optional<? extends T> var1);

    @$Beta
    public abstract T or($Supplier<? extends T> var1);

    public abstract @Nullable T orNull();

    public abstract Set<T> asSet();

    public abstract <V> $Optional<V> transform($Function<? super T, V> var1);

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @$Beta
    public static <T> Iterable<T> presentInstances(final Iterable<? extends $Optional<? extends T>> optionals) {
        $Preconditions.checkNotNull(optionals);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new $AbstractIterator<T>(){
                    private final Iterator<? extends $Optional<? extends T>> iterator;
                    {
                        this.iterator = $Preconditions.checkNotNull(optionals.iterator());
                    }

                    @Override
                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            $Optional optional = this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return optional.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }
}

