/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.ArrayProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.ListProjectionAccumulator;
import org.hibernate.search.engine.search.projection.spi.OptionalProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.SetProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.SimpleProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.SingleValuedProjectionAccumulator;
import org.hibernate.search.engine.search.projection.spi.SortedSetComparatorProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.SortedSetProjectionCollector;

public interface BuiltInProjectionCollectors {
    public static <V> ProjectionCollector.Provider<V, V> nullable() {
        return SingleValuedProjectionAccumulator.PROVIDER;
    }

    public static <V> ProjectionCollector.Provider<V, List<V>> list() {
        return ListProjectionAccumulator.PROVIDER;
    }

    public static <V, C> ProjectionCollector.Provider<V, C> simple(Function<List<V>, C> converter) {
        return new SimpleProjectionCollector.Provider<V, C>(converter);
    }

    public static <V> ProjectionCollector.Provider<V, V[]> array(Class<? super V> componentType) {
        return ArrayProjectionCollector.provider(componentType);
    }

    public static <V> ProjectionCollector.Provider<V, Set<V>> set() {
        return SetProjectionCollector.PROVIDER;
    }

    public static <V> ProjectionCollector.Provider<V, SortedSet<V>> sortedSet() {
        return SortedSetProjectionCollector.PROVIDER;
    }

    public static <V> ProjectionCollector.Provider<V, SortedSet<V>> sortedSet(Comparator<? super V> comparator) {
        return SortedSetComparatorProjectionCollector.provider(comparator);
    }

    public static <V> ProjectionCollector.Provider<V, Optional<V>> optional() {
        return OptionalProjectionCollector.PROVIDER;
    }
}

