/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyClass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.AccessTypeInformation;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ImportContextImpl;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaAttribute;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaCollection;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaMap;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaSingleAttribute;
import org.hibernate.jpamodelgen.model.ImportContext;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;

public class AnnotationMetaEntity
implements MetaEntity {
    protected final ImportContext importContext;
    protected final TypeElement element;
    protected final Map<String, MetaAttribute> members;
    protected Context context;
    private AccessTypeInformation entityAccessTypeInfo;

    public AnnotationMetaEntity(TypeElement element, Context context) {
        this(element, context, false);
    }

    protected AnnotationMetaEntity(TypeElement element, Context context, boolean lazilyInitialised) {
        this.element = element;
        this.context = context;
        this.members = new HashMap<String, MetaAttribute>();
        this.importContext = new ImportContextImpl(this.getPackageName());
        if (!lazilyInitialised) {
            this.init();
        }
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public String getQualifiedName() {
        return this.element.getQualifiedName().toString();
    }

    @Override
    public String getPackageName() {
        PackageElement packageOf = this.context.getElementUtils().getPackageOf(this.element);
        return this.context.getElementUtils().getName(packageOf.getQualifiedName()).toString();
    }

    @Override
    public List<MetaAttribute> getMembers() {
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    @Override
    public boolean isMetaComplete() {
        return false;
    }

    public void mergeInMembers(Collection<MetaAttribute> attributes) {
        for (MetaAttribute attribute : attributes) {
            this.members.put(attribute.getPropertyName(), attribute);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnnotationMetaEntity");
        sb.append("{element=").append(this.element);
        sb.append(", members=").append(this.members);
        sb.append('}');
        return sb.toString();
    }

    private void addPersistentMembers(List<? extends Element> membersOfClass, AccessType membersKind) {
        for (Element element : membersOfClass) {
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(element);
            if (this.entityAccessTypeInfo.getAccessType() != membersKind && forcedAccessType == null || TypeUtils.containsAnnotation(element, Transient.class) || element.getModifiers().contains((Object)Modifier.TRANSIENT) || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            TypeVisitor visitor = new TypeVisitor(this);
            AnnotationMetaAttribute result = element.asType().accept(visitor, element);
            if (result == null) continue;
            this.members.put(result.getPropertyName(), result);
        }
    }

    protected void init() {
        TypeUtils.determineAccessTypeForHierarchy(this.element, this.context);
        this.entityAccessTypeInfo = this.context.getAccessTypeInfo(this.getQualifiedName());
        List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(this.element.getEnclosedElements());
        this.addPersistentMembers(fieldsOfClass, AccessType.FIELD);
        List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.element.getEnclosedElements());
        this.addPersistentMembers(methodsOfClass, AccessType.PROPERTY);
    }

    @Override
    public String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public String importType(Name qualifiedName) {
        return this.importType(qualifiedName.toString());
    }

    @Override
    public TypeElement getTypeElement() {
        return this.element;
    }

    class BasicAttributeVisitor
    extends SimpleTypeVisitor6<Boolean, Element> {
        BasicAttributeVisitor() {
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType t, Element element) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitArray(ArrayType t, Element element) {
            TypeMirror componentMirror = t.getComponentType();
            TypeElement componentElement = (TypeElement)AnnotationMetaEntity.this.context.getTypeUtils().asElement(componentMirror);
            return Constants.BASIC_ARRAY_TYPES.contains(componentElement.getQualifiedName().toString());
        }

        @Override
        public Boolean visitDeclared(DeclaredType declaredType, Element element) {
            if (ElementKind.ENUM.equals((Object)element.getKind())) {
                return Boolean.TRUE;
            }
            if (ElementKind.CLASS.equals((Object)element.getKind())) {
                TypeElement typeElement = (TypeElement)element;
                String typeName = typeElement.getQualifiedName().toString();
                if (Constants.BASIC_TYPES.contains(typeName)) {
                    return Boolean.TRUE;
                }
                if (TypeUtils.containsAnnotation(element, Embeddable.class)) {
                    return Boolean.TRUE;
                }
                for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                    TypeElement interfaceElement = (TypeElement)AnnotationMetaEntity.this.context.getTypeUtils().asElement(typeMirror);
                    if (!"java.io.Serializable".equals(interfaceElement.getQualifiedName().toString())) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
    }

    class TypeVisitor
    extends SimpleTypeVisitor6<AnnotationMetaAttribute, Element> {
        AnnotationMetaEntity parent;

        TypeVisitor(AnnotationMetaEntity parent) {
            this.parent = parent;
        }

        @Override
        public AnnotationMetaAttribute visitPrimitive(PrimitiveType t, Element element) {
            return new AnnotationMetaSingleAttribute(this.parent, element, TypeUtils.toTypeString(t));
        }

        @Override
        public AnnotationMetaAttribute visitArray(ArrayType t, Element element) {
            return new AnnotationMetaSingleAttribute(this.parent, element, TypeUtils.toTypeString(t));
        }

        @Override
        public AnnotationMetaAttribute visitDeclared(DeclaredType declaredType, Element element) {
            TypeElement returnedElement = (TypeElement)AnnotationMetaEntity.this.context.getTypeUtils().asElement(declaredType);
            String fqNameOfReturnType = returnedElement.getQualifiedName().toString();
            String collection = Constants.COLLECTIONS.get(fqNameOfReturnType);
            String targetEntity = this.getTargetEntity(element.getAnnotationMirrors());
            if (collection != null) {
                if (TypeUtils.containsAnnotation(element, ElementCollection.class)) {
                    String explicitTargetEntity = this.getTargetEntity(element.getAnnotationMirrors());
                    TypeMirror collectionElementType = TypeUtils.getCollectionElementType(declaredType, fqNameOfReturnType, explicitTargetEntity, AnnotationMetaEntity.this.context);
                    TypeElement collectionElement = (TypeElement)AnnotationMetaEntity.this.context.getTypeUtils().asElement(collectionElementType);
                    AccessTypeInformation accessTypeInfo = AnnotationMetaEntity.this.context.getAccessTypeInfo(collectionElement.getQualifiedName().toString());
                    if (accessTypeInfo == null) {
                        AccessType explicitAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(collectionElement);
                        accessTypeInfo = new AccessTypeInformation(collectionElement.getQualifiedName().toString(), explicitAccessType, AnnotationMetaEntity.this.entityAccessTypeInfo.getAccessType());
                        AnnotationMetaEntity.this.context.addAccessTypeInformation(collectionElement.getQualifiedName().toString(), accessTypeInfo);
                    } else {
                        accessTypeInfo.setDefaultAccessType(AnnotationMetaEntity.this.entityAccessTypeInfo.getAccessType());
                    }
                }
                if (collection.equals("javax.persistence.metamodel.MapAttribute")) {
                    return this.createAnnotationMetaAttributeForMap(declaredType, element, collection, targetEntity);
                }
                return new AnnotationMetaCollection(this.parent, element, collection, this.getElementType(declaredType, targetEntity));
            }
            if (this.isBasicAttribute(element, returnedElement)) {
                return new AnnotationMetaSingleAttribute(this.parent, element, returnedElement.getQualifiedName().toString());
            }
            return null;
        }

        @Override
        public AnnotationMetaAttribute visitExecutable(ExecutableType t, Element p) {
            if (!p.getKind().equals((Object)ElementKind.METHOD)) {
                return null;
            }
            String string = p.getSimpleName().toString();
            if (!StringUtil.isPropertyName(string)) {
                return null;
            }
            TypeMirror returnType = t.getReturnType();
            return returnType.accept(this, p);
        }

        private boolean isBasicAttribute(Element element, Element returnedElement) {
            if (TypeUtils.containsAnnotation(element, Basic.class) || TypeUtils.containsAnnotation(element, OneToOne.class) || TypeUtils.containsAnnotation(element, ManyToOne.class)) {
                return true;
            }
            BasicAttributeVisitor basicVisitor = new BasicAttributeVisitor();
            return returnedElement.asType().accept(basicVisitor, returnedElement);
        }

        private AnnotationMetaAttribute createAnnotationMetaAttributeForMap(DeclaredType declaredType, Element element, String collection, String targetEntity) {
            String keyType;
            if (TypeUtils.containsAnnotation(element, MapKeyClass.class)) {
                TypeMirror typeMirror = (TypeMirror)TypeUtils.getAnnotationValue(TypeUtils.getAnnotationMirror(element, MapKeyClass.class), "value");
                keyType = ((Object)typeMirror).toString();
            } else {
                keyType = TypeUtils.getKeyType(declaredType, AnnotationMetaEntity.this.context);
            }
            return new AnnotationMetaMap(this.parent, element, collection, keyType, this.getElementType(declaredType, targetEntity));
        }

        private String getElementType(DeclaredType declaredType, String targetEntity) {
            if (targetEntity != null) {
                return targetEntity;
            }
            List<? extends TypeMirror> mirrors = declaredType.getTypeArguments();
            if (mirrors.size() == 1) {
                TypeMirror type = mirrors.get(0);
                return TypeUtils.extractClosestRealTypeAsString(type, AnnotationMetaEntity.this.context);
            }
            if (mirrors.size() == 2) {
                return TypeUtils.extractClosestRealTypeAsString(mirrors.get(1), AnnotationMetaEntity.this.context);
            }
            if (mirrors.size() > 2) {
                AnnotationMetaEntity.this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to find the closest solid type" + declaredType);
            }
            return "?";
        }

        private String getTargetEntity(List<? extends AnnotationMirror> annotations) {
            String fullyQualifiedTargetEntityName = null;
            for (AnnotationMirror annotationMirror : annotations) {
                if (TypeUtils.isAnnotationMirrorOfType(annotationMirror, ElementCollection.class)) {
                    fullyQualifiedTargetEntityName = this.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "targetClass");
                    continue;
                }
                if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, OneToMany.class) && !TypeUtils.isAnnotationMirrorOfType(annotationMirror, ManyToMany.class) && !TypeUtils.isAnnotationMirrorOfType(annotationMirror, ManyToOne.class) && !TypeUtils.isAnnotationMirrorOfType(annotationMirror, OneToOne.class)) continue;
                fullyQualifiedTargetEntityName = this.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "targetEntity");
            }
            return fullyQualifiedTargetEntityName;
        }

        private String getFullyQualifiedClassNameOfTargetEntity(AnnotationMirror mirror, String parameterName) {
            TypeMirror parameterType;
            assert (mirror != null);
            assert (parameterName != null);
            String targetEntityName = null;
            Object parameterValue = TypeUtils.getAnnotationValue(mirror, parameterName);
            if (parameterValue != null && !(parameterType = (TypeMirror)parameterValue).getKind().equals((Object)TypeKind.VOID)) {
                targetEntityName = ((Object)parameterType).toString();
            }
            return targetEntityName;
        }
    }
}

