/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;

public class EntitiesModifiedAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;

    public EntitiesModifiedAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, Number revision) {
        super(enversService, versionsReader, cls);
        this.revision = revision;
    }

    public EntitiesModifiedAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision) {
        super(enversService, versionsReader, cls, entityName);
        this.revision = revision;
    }

    @Override
    public List list() {
        AuditEntitiesConfiguration verEntCfg = this.enversService.getAuditEntitiesConfiguration();
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        this.qb.getRootParameters().addWhereWithParam(revisionPropertyPath, "=", this.revision);
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.enversService, this.versionsReader, this.entityName, this.qb, this.qb.getRootParameters());
        }
        Query query = this.buildQuery();
        List queryResult = query.list();
        if (this.hasProjection) {
            return queryResult;
        }
        ArrayList result = new ArrayList();
        this.entityInstantiator.addInstancesFromVersionsEntities(this.entityName, result, queryResult, this.revision);
        return result;
    }
}

